/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.MediaType;
import io.jooby.SneakyThrows;
import io.jooby.handler.Asset;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarAsset
implements Asset {
    private final ZipEntry entry;
    private final JarFile jar;

    public JarAsset(JarURLConnection connection) throws IOException {
        connection.setUseCaches(false);
        this.jar = connection.getJarFile();
        this.entry = this.jar.getEntry(connection.getEntryName());
    }

    @Override
    public boolean isDirectory() {
        return this.entry.isDirectory();
    }

    @Override
    public long getSize() {
        return this.entry.getSize();
    }

    @Override
    public long getLastModified() {
        return this.entry.getTime();
    }

    @Override
    @NonNull
    public MediaType getContentType() {
        return MediaType.byFile(this.entry.getName());
    }

    @Override
    public InputStream stream() {
        try {
            return this.jar.getInputStream(this.entry);
        }
        catch (IOException x) {
            throw SneakyThrows.propagate(x);
        }
    }

    @Override
    public void close() {
        try {
            this.jar.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

