/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

public class LocaleUtils {
    public static Optional<List<Locale.LanguageRange>> parseRanges(String value) {
        if (value == null) {
            return Optional.empty();
        }
        String wellFormed = value;
        if (wellFormed.endsWith(";")) {
            wellFormed = wellFormed.substring(0, wellFormed.length() - 1);
        }
        try {
            return Optional.of(Locale.LanguageRange.parse(wellFormed).stream().sorted(Comparator.comparing(Locale.LanguageRange::getWeight).reversed()).collect(Collectors.toList()));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static Optional<List<Locale>> parseLocales(String value) {
        return LocaleUtils.parseRanges(value).map(l -> l.stream().map(r -> Locale.forLanguageTag(r.getRange())).collect(Collectors.toList()));
    }
}

