/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.ValueNode;
import io.jooby.exception.MissingValueException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MissingValue
implements ValueNode {
    private String name;

    public MissingValue(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @NonNull
    public ValueNode get(@NonNull String name) {
        return this.name.equals(name) ? this : new MissingValue(this.name + "." + name);
    }

    @Override
    @NonNull
    public ValueNode get(int index) {
        return new MissingValue(this.name + "[" + index + "]");
    }

    @Override
    @NonNull
    public <T> T to(@NonNull Class<T> type) {
        throw new MissingValueException(this.name);
    }

    @Override
    @Nullable
    public <T> T toNullable(@NonNull Class<T> type) {
        return null;
    }

    @Override
    public String value() {
        throw new MissingValueException(this.name);
    }

    @Override
    @NonNull
    public Map<String, String> toMap() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, List<String>> toMultimap() {
        return Collections.emptyMap();
    }

    @Override
    @NonNull
    public List<String> toList() {
        return Collections.emptyList();
    }

    @Override
    @NonNull
    public Optional<String> toOptional() {
        return Optional.empty();
    }

    @Override
    @NonNull
    public <T> List<T> toList(@NonNull Class<T> type) {
        return Collections.emptyList();
    }

    @Override
    @NonNull
    public Set<String> toSet() {
        return Collections.emptySet();
    }

    @Override
    @NonNull
    public <T> Set<T> toSet(@NonNull Class<T> type) {
        return Collections.emptySet();
    }

    public String toString() {
        return "<missing>";
    }

    public boolean equals(Object o) {
        if (o instanceof MissingValue) {
            return Objects.equals(this.name, ((MissingValue)o).name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

