/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.FileUpload;
import io.jooby.Formdata;
import io.jooby.SneakyThrows;
import io.jooby.internal.HashValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class MultipartNode
extends HashValue
implements Formdata {
    private Map<String, List<FileUpload>> files = new HashMap<String, List<FileUpload>>();

    public MultipartNode(Context ctx) {
        super(ctx);
    }

    @Override
    public void put(String name, FileUpload file) {
        this.files.computeIfAbsent(name, k -> new ArrayList()).add(file);
    }

    @Override
    @NonNull
    public List<FileUpload> files() {
        return this.files.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    @NonNull
    public List<FileUpload> files(@NonNull String name) {
        return this.files.getOrDefault(name, Collections.emptyList());
    }

    @Override
    @NonNull
    public FileUpload file(@NonNull String name) {
        List<FileUpload> files = this.files(name);
        if (files.isEmpty()) {
            String error = "Field '" + name + "' is missing";
            throw SneakyThrows.propagate(new NoSuchElementException(error));
        }
        return files.get(0);
    }
}

