/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.ByteRange;
import io.jooby.Context;
import io.jooby.StatusCode;
import io.jooby.exception.StatusCodeException;
import java.io.IOException;
import java.io.InputStream;

public class NotSatisfiableByteRange
implements ByteRange {
    private String value;
    private long contentLength;

    public NotSatisfiableByteRange(String value, long contentLength) {
        this.value = value;
        this.contentLength = contentLength;
    }

    @Override
    public long getStart() {
        return -1L;
    }

    @Override
    public long getEnd() {
        return -1L;
    }

    @Override
    @NonNull
    public StatusCode getStatusCode() {
        return StatusCode.REQUESTED_RANGE_NOT_SATISFIABLE;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    @NonNull
    public String getContentRange() {
        return "bytes */" + this.contentLength;
    }

    @Override
    @NonNull
    public ByteRange apply(@NonNull Context ctx) {
        throw new StatusCodeException(StatusCode.REQUESTED_RANGE_NOT_SATISFIABLE, this.value);
    }

    @Override
    @NonNull
    public InputStream apply(@NonNull InputStream input) throws IOException {
        throw new StatusCodeException(StatusCode.REQUESTED_RANGE_NOT_SATISFIABLE, this.value);
    }
}

