/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import io.jooby.Context;

public class ProxyPeerAddress {
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
    private static final String X_FORWARDED_HOST = "X-Forwarded-Host";
    private static final String X_FORWARDED_PORT = "X-Forwarded-Port";
    private String remoteAddress;
    private String scheme;
    private String host;
    private int port;

    private ProxyPeerAddress() {
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void set(Context ctx) {
        ctx.setRemoteAddress(this.getRemoteAddress());
        ctx.setHost(this.getHost());
        ctx.setScheme(this.getScheme());
        ctx.setPort(this.getPort());
    }

    public static ProxyPeerAddress parse(Context ctx) {
        ProxyPeerAddress result = new ProxyPeerAddress();
        String forwardedFor = ctx.header(X_FORWARDED_FOR).toOptional().orElseGet(ctx::getRemoteAddress);
        result.remoteAddress = ProxyPeerAddress.mostRecent(forwardedFor);
        String forwardedProto = ctx.header(X_FORWARDED_PROTO).toOptional().orElseGet(ctx::getScheme);
        result.scheme = ProxyPeerAddress.mostRecent(forwardedProto);
        String forwardedHost = ctx.header(X_FORWARDED_HOST).toOptional().orElseGet(ctx::getHost);
        String forwardedPort = ctx.header(X_FORWARDED_PORT).valueOrNull();
        String value = ProxyPeerAddress.mostRecent(forwardedHost);
        if (value.startsWith("[")) {
            int index;
            int end = value.lastIndexOf("]");
            if (end == -1) {
                end = 0;
            }
            if ((index = value.indexOf(":", end)) != -1) {
                forwardedPort = value.substring(index + 1);
                value = value.substring(0, index);
            }
        } else {
            int index = value.lastIndexOf(":");
            if (index != -1) {
                forwardedPort = value.substring(index + 1);
                value = value.substring(0, index);
            }
        }
        String hostHeader = value;
        if (forwardedPort != null) {
            try {
                result.port = Integer.parseInt(ProxyPeerAddress.mostRecent(forwardedPort));
            }
            catch (NumberFormatException ignore) {
                result.port = ProxyPeerAddress.defaultPort(ctx, hostHeader);
            }
        } else {
            result.port = ProxyPeerAddress.defaultPort(ctx, hostHeader);
        }
        result.host = hostHeader;
        return result;
    }

    private static int defaultPort(Context ctx, String host) {
        if ("localhost".equals(host)) {
            return ctx.getServerPort();
        }
        return ctx.isSecure() ? 443 : 80;
    }

    private static String mostRecent(String header) {
        int index = header.indexOf(44);
        if (index == -1) {
            return header;
        }
        return header.substring(0, index);
    }
}

