/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.converter;

import io.jooby.Value;
import io.jooby.ValueConverter;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class LocalDateConverter
implements ValueConverter {
    @Override
    public boolean supports(Class type) {
        return type == LocalDate.class;
    }

    public Object convert(Value value, Class type) {
        try {
            Instant instant = Instant.ofEpochMilli(Long.parseLong(value.value()));
            return instant.atZone(ZoneId.systemDefault()).toLocalDate();
        }
        catch (NumberFormatException x) {
            return LocalDate.parse(value.value(), DateTimeFormatter.ISO_LOCAL_DATE);
        }
    }
}

