/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.unbescape.json;

import io.jooby.internal.unbescape.json.JsonEscapeLevel;
import io.jooby.internal.unbescape.json.JsonEscapeType;
import java.util.Arrays;

public final class JsonEscapeUtil {
    private static final char ESCAPE_PREFIX = '\\';
    private static final char[] ESCAPE_UHEXA_PREFIX;
    private static char[] HEXA_CHARS_UPPER;
    private static int SEC_CHARS_LEN;
    private static char SEC_CHARS_NO_SEC;
    private static char[] SEC_CHARS;
    private static final char ESCAPE_LEVELS_LEN = '\u00a1';
    private static final byte[] ESCAPE_LEVELS;

    private JsonEscapeUtil() {
    }

    static char[] toUHexa(int codepoint) {
        char[] result = new char[4];
        result[3] = HEXA_CHARS_UPPER[codepoint % 16];
        result[2] = HEXA_CHARS_UPPER[(codepoint >>> 4) % 16];
        result[1] = HEXA_CHARS_UPPER[(codepoint >>> 8) % 16];
        result[0] = HEXA_CHARS_UPPER[(codepoint >>> 12) % 16];
        return result;
    }

    public static String escape(String text, JsonEscapeType escapeType, JsonEscapeLevel escapeLevel) {
        int level = escapeLevel.getEscapeLevel();
        boolean useSECs = escapeType.getUseSECs();
        StringBuilder strBuilder = null;
        boolean offset = false;
        int max = text.length();
        int readOffset = 0;
        for (int i = 0; i < max; ++i) {
            char sec;
            int codepoint = Character.codePointAt(text, i);
            if (codepoint <= 159 && level < ESCAPE_LEVELS[codepoint] || codepoint == 47 && level < 3 && (i == 0 || text.charAt(i - 1) != '<')) continue;
            if (codepoint > 159 && level < ESCAPE_LEVELS[160]) {
                if (Character.charCount(codepoint) <= 1) continue;
                ++i;
                continue;
            }
            if (strBuilder == null) {
                strBuilder = new StringBuilder(max + 20);
            }
            if (i - readOffset > 0) {
                strBuilder.append(text, readOffset, i);
            }
            if (Character.charCount(codepoint) > 1) {
                ++i;
            }
            readOffset = i + 1;
            if (useSECs && codepoint < SEC_CHARS_LEN && (sec = SEC_CHARS[codepoint]) != SEC_CHARS_NO_SEC) {
                strBuilder.append('\\');
                strBuilder.append(sec);
                continue;
            }
            if (Character.charCount(codepoint) > 1) {
                char[] codepointChars = Character.toChars(codepoint);
                strBuilder.append(ESCAPE_UHEXA_PREFIX);
                strBuilder.append(JsonEscapeUtil.toUHexa(codepointChars[0]));
                strBuilder.append(ESCAPE_UHEXA_PREFIX);
                strBuilder.append(JsonEscapeUtil.toUHexa(codepointChars[1]));
                continue;
            }
            strBuilder.append(ESCAPE_UHEXA_PREFIX);
            strBuilder.append(JsonEscapeUtil.toUHexa(codepoint));
        }
        if (strBuilder == null) {
            return text;
        }
        if (max - readOffset > 0) {
            strBuilder.append(text, readOffset, max);
        }
        return strBuilder.toString();
    }

    static {
        int c;
        ESCAPE_UHEXA_PREFIX = "\\u".toCharArray();
        HEXA_CHARS_UPPER = "0123456789ABCDEF".toCharArray();
        SEC_CHARS_LEN = 93;
        SEC_CHARS_NO_SEC = (char)42;
        SEC_CHARS = new char[SEC_CHARS_LEN];
        Arrays.fill(SEC_CHARS, SEC_CHARS_NO_SEC);
        JsonEscapeUtil.SEC_CHARS[8] = 98;
        JsonEscapeUtil.SEC_CHARS[9] = 116;
        JsonEscapeUtil.SEC_CHARS[10] = 110;
        JsonEscapeUtil.SEC_CHARS[12] = 102;
        JsonEscapeUtil.SEC_CHARS[13] = 114;
        JsonEscapeUtil.SEC_CHARS[34] = 34;
        JsonEscapeUtil.SEC_CHARS[92] = 92;
        JsonEscapeUtil.SEC_CHARS[47] = 47;
        ESCAPE_LEVELS = new byte[161];
        Arrays.fill(ESCAPE_LEVELS, (byte)3);
        for (c = 128; c < 161; c = (int)((char)(c + 1))) {
            JsonEscapeUtil.ESCAPE_LEVELS[c] = 2;
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            JsonEscapeUtil.ESCAPE_LEVELS[c] = 4;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            JsonEscapeUtil.ESCAPE_LEVELS[c] = 4;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            JsonEscapeUtil.ESCAPE_LEVELS[c] = 4;
        }
        JsonEscapeUtil.ESCAPE_LEVELS[8] = 1;
        JsonEscapeUtil.ESCAPE_LEVELS[9] = 1;
        JsonEscapeUtil.ESCAPE_LEVELS[10] = 1;
        JsonEscapeUtil.ESCAPE_LEVELS[12] = 1;
        JsonEscapeUtil.ESCAPE_LEVELS[13] = 1;
        JsonEscapeUtil.ESCAPE_LEVELS[34] = 1;
        JsonEscapeUtil.ESCAPE_LEVELS[92] = 1;
        JsonEscapeUtil.ESCAPE_LEVELS[47] = 1;
        JsonEscapeUtil.ESCAPE_LEVELS[38] = 1;
        for (c = 0; c <= 31; c = (int)((char)(c + 1))) {
            JsonEscapeUtil.ESCAPE_LEVELS[c] = 1;
        }
        for (c = 127; c <= 159; c = (int)((char)(c + 1))) {
            JsonEscapeUtil.ESCAPE_LEVELS[c] = 1;
        }
    }
}

