/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.x509;

import io.jooby.internal.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.KeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PemReader {
    private static final Pattern CERT_PATTERN = Pattern.compile("-+BEGIN\\s+.*CERTIFICATE[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*CERTIFICATE[^-]*-+", 2);
    private static final Pattern KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);

    static List<ByteBuffer> readCertificates(InputStream file) throws CertificateException, IOException {
        String content = IOUtils.toString(file, StandardCharsets.UTF_8);
        ArrayList<ByteBuffer> certs = new ArrayList<ByteBuffer>();
        Matcher m = CERT_PATTERN.matcher(content);
        int start = 0;
        while (m.find(start)) {
            ByteBuffer buffer = ByteBuffer.wrap(PemReader.decode(m.group(1)));
            certs.add(buffer);
            start = m.end();
        }
        if (certs.isEmpty()) {
            throw new CertificateException("found no certificates: " + String.valueOf(file));
        }
        return certs;
    }

    private static byte[] decode(String value) {
        return Base64.getDecoder().decode(value.replaceAll("(?:\\r\\n|\\n\\r|\\n|\\r)", ""));
    }

    static ByteBuffer readPrivateKey(InputStream file) throws KeyException, IOException {
        String content = IOUtils.toString(file, StandardCharsets.US_ASCII);
        Matcher m = KEY_PATTERN.matcher(content);
        if (!m.find()) {
            throw new KeyException("found no private key: " + String.valueOf(file));
        }
        String value = m.group(1);
        return ByteBuffer.wrap(PemReader.decode(value));
    }

    private PemReader() {
    }
}

