/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.problem;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.StatusCode;
import java.net.URI;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HttpProblem
extends RuntimeException {
    private static final String INTERNAL_ERROR_TITLE = StatusCode.SERVER_ERROR.reason();
    private static final String INTERNAL_ERROR_DETAIL = "The server encountered an error or misconfiguration and was unable to complete your request";
    private static final URI DEFAULT_TYPE = URI.create("about:blank");
    private final String timestamp = Instant.now().toString();
    private final URI type;
    private final String title;
    private final int status;
    private final String detail;
    private final URI instance;
    private final List<Error> errors;
    private final Map<String, Object> parameters;
    private final Map<String, Object> headers;

    protected HttpProblem(Builder builder) {
        super(HttpProblem.createMessage(builder.title, builder.detail));
        this.type = builder.type == null ? DEFAULT_TYPE : builder.type;
        this.title = builder.title;
        this.status = builder.status;
        this.detail = builder.detail;
        this.instance = builder.instance;
        this.errors = Collections.unmodifiableList(builder.errors);
        this.parameters = Collections.unmodifiableMap(builder.parameters);
        this.headers = Collections.unmodifiableMap(builder.headers);
    }

    private static String createMessage(String title, String detail) {
        return Objects.isNull(detail) ? title : title + ": " + detail;
    }

    public static HttpProblem valueOf(StatusCode status, String title) {
        return HttpProblem.builder().title(title).status(status).build();
    }

    public static HttpProblem valueOf(StatusCode status, String title, String detail) {
        return HttpProblem.builder().title(title).status(status).detail(detail).build();
    }

    public static HttpProblem valueOf(StatusCode status) {
        return HttpProblem.builder().title(status.reason()).status(status).build();
    }

    public static HttpProblem internalServerError() {
        return HttpProblem.builder().title(INTERNAL_ERROR_TITLE).status(StatusCode.SERVER_ERROR).detail(INTERNAL_ERROR_DETAIL).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public URI getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public int getStatus() {
        return this.status;
    }

    @Nullable
    public String getDetail() {
        return this.detail;
    }

    @Nullable
    public URI getInstance() {
        return this.instance;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public String toString() {
        return "HttpProblem{timestamp='" + this.timestamp + "', type=" + String.valueOf(this.type) + ", title='" + this.title + "', status=" + this.status + ", detail='" + this.detail + "', instance=" + String.valueOf(this.instance) + (String)(this.hasErrors() ? ", errors=" + String.valueOf(this.errors) : "") + (String)(this.hasParameters() ? ", parameters=" + String.valueOf(this.parameters) : "") + "}";
    }

    public static class Builder {
        private URI type;
        private String title;
        private int status;
        private String detail;
        private URI instance;
        private final Map<String, Object> parameters = new LinkedHashMap<String, Object>();
        private final Map<String, Object> headers = new LinkedHashMap<String, Object>();
        private final List<Error> errors = new LinkedList<Error>();

        Builder() {
        }

        public Builder type(@Nullable URI type) {
            this.type = type;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder status(StatusCode status) {
            this.status = status.value();
            return this;
        }

        public Builder detail(@Nullable String detail) {
            this.detail = detail;
            return this;
        }

        public Builder instance(@Nullable URI instance) {
            this.instance = instance;
            return this;
        }

        public Builder header(String headerName, Object value) {
            this.headers.put(headerName, value);
            return this;
        }

        public Builder error(Error error) {
            this.errors.add(error);
            return this;
        }

        public Builder errors(List<? extends Error> errors) {
            this.errors.addAll(errors);
            return this;
        }

        public Builder param(String key, @Nullable Object value) {
            this.parameters.put(key, value);
            return this;
        }

        public HttpProblem build() {
            if (this.title == null || this.title.isEmpty() || this.title.isBlank()) {
                throw new RuntimeException("The problem 'title' should be specified");
            }
            if (this.status == 0) {
                throw new RuntimeException("The problem 'status' should be specified");
            }
            if (this.status < 400) {
                throw new RuntimeException("Illegal status code " + this.status + ". Problem details designed to serve 4xx and 5xx status codes");
            }
            return new HttpProblem(this);
        }
    }

    public static class Error {
        private final String detail;
        private final String pointer;

        public Error(String detail, String pointer) {
            this.detail = detail;
            this.pointer = pointer;
        }

        public String getDetail() {
            return this.detail;
        }

        public String getPointer() {
            return this.pointer;
        }
    }
}

