/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks.annotationparameters;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.checks.annotationparameters.AnnotationParametersAbstractCheck;
import org.hibernate.validator.ap.internal.util.AnnotationApiHelper;
import org.hibernate.validator.ap.internal.util.CollectionHelper;

public class AnnotationParametersDecimalMinMaxCheck
extends AnnotationParametersAbstractCheck {
    public AnnotationParametersDecimalMinMaxCheck(AnnotationApiHelper annotationApiHelper) {
        super(annotationApiHelper, "jakarta.validation.constraints.DecimalMin", "jakarta.validation.constraints.DecimalMax");
    }

    @Override
    protected Set<ConstraintCheckIssue> doCheck(Element element, AnnotationMirror annotation) {
        String value = (String)this.annotationApiHelper.getAnnotationValue(annotation, "value").getValue();
        try {
            new BigDecimal(value);
            return Collections.emptySet();
        }
        catch (NumberFormatException nfe) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, "INVALID_DECIMAL_MIN_MAX_ANNOTATION_PARAMETERS", new Object[0]));
        }
    }
}

