/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

@FunctionalInterface
public interface Awaitable {
    public static final Executor executor = Executors.newCachedThreadPool();

    public void await() throws Exception;

    default public void awaitSilently() {
        this.await();
    }

    default public CompletableFuture<Void> asCompletableFuture() {
        return CompletableFuture.runAsync(this::awaitSilently, executor);
    }

    default public Awaitable join(Awaitable other) {
        return () -> {
            this.await();
            other.await();
        };
    }

    public static Awaitable ready() {
        return () -> {};
    }

    public static Awaitable failed(Exception e) {
        return () -> {
            throw e;
        };
    }

    public static Awaitable fromFuture(Future<?> future, Duration timeout) {
        return () -> future.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static Awaitable fromFuture(Future<?> future) {
        return future::get;
    }
}

