/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.ErrorHandler;
import io.fluxcapacitor.common.Monitored;
import io.fluxcapacitor.common.Registration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Backlog<T>
implements Monitored<List<T>> {
    private static final Logger log = LoggerFactory.getLogger(Backlog.class);
    private final int maxBatchSize;
    private final Queue<T> queue = new ConcurrentLinkedQueue<T>();
    private final BatchConsumer<T> consumer;
    private final ErrorHandler<List<T>> errorHandler;
    private final ExecutorService executorService;
    private final AtomicBoolean flushing = new AtomicBoolean();
    private final AtomicLong insertPosition = new AtomicLong();
    private final AtomicLong flushPosition = new AtomicLong();
    private final AtomicReference<Awaitable> syncObject = new AtomicReference();
    private final Collection<Consumer<List<T>>> monitors = new CopyOnWriteArraySet<Consumer<List<T>>>();

    public Backlog(BatchConsumer<T> consumer) {
        this(consumer, 1024);
    }

    public Backlog(BatchConsumer<T> consumer, int maxBatchSize) {
        this(consumer, maxBatchSize, 1, (e, batch) -> log.error("Consumer {} failed to handle batch {}. Continuing with next batch.", consumer, batch, e));
    }

    public Backlog(BatchConsumer<T> consumer, int maxBatchSize, int threads, ErrorHandler<List<T>> errorHandler) {
        this.maxBatchSize = maxBatchSize;
        this.consumer = consumer;
        this.executorService = Executors.newFixedThreadPool(threads);
        this.errorHandler = errorHandler;
    }

    @SafeVarargs
    public final Awaitable add(T ... values2) {
        Collections.addAll(this.queue, values2);
        return values2.length == 0 ? Awaitable.ready() : this.awaitFlush(this.insertPosition.updateAndGet(p -> p + (long)values2.length));
    }

    public Awaitable add(Collection<? extends T> values2) {
        this.queue.addAll(values2);
        return values2.isEmpty() ? Awaitable.ready() : this.awaitFlush(this.insertPosition.updateAndGet(p -> p + (long)values2.size()));
    }

    private Awaitable awaitFlush(long position) {
        this.flushIfNotFlushing();
        return () -> {
            AtomicReference<Awaitable> atomicReference = this.syncObject;
            synchronized (atomicReference) {
                while (position > this.flushPosition.get()) {
                    this.syncObject.wait();
                }
                Awaitable externalProcess = this.syncObject.get();
                if (externalProcess != null) {
                    externalProcess.await();
                }
            }
        };
    }

    private void flushIfNotFlushing() {
        if (this.flushing.compareAndSet(false, true)) {
            this.executorService.execute(this::flush);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        try {
            while (!this.queue.isEmpty()) {
                Awaitable awaitable;
                T value;
                ArrayList batch = new ArrayList(this.maxBatchSize);
                while (batch.size() < this.maxBatchSize && (value = this.queue.poll()) != null) {
                    batch.add(value);
                }
                try {
                    awaitable = this.consumer.accept(batch);
                }
                catch (Exception e) {
                    awaitable = Awaitable.failed(e);
                    this.errorHandler.handleError(e, batch);
                }
                this.syncObject.set(awaitable);
                this.flushPosition.addAndGet(batch.size());
                AtomicReference<Awaitable> atomicReference = this.syncObject;
                synchronized (atomicReference) {
                    this.syncObject.notifyAll();
                }
                this.monitors.forEach(m -> m.accept(batch));
            }
            this.flushing.set(false);
            if (!this.queue.isEmpty()) {
                this.flushIfNotFlushing();
            }
        }
        catch (Exception e) {
            log.error("Failed to flush the backlog", e);
            this.flushing.set(false);
            throw e;
        }
    }

    @Override
    public Registration registerMonitor(Consumer<List<T>> monitor) {
        this.monitors.add(monitor);
        return () -> this.monitors.remove(monitor);
    }

    public void shutDown() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Shutdown of executor was interrupted", e);
            Thread.currentThread().interrupt();
        }
    }

    @FunctionalInterface
    public static interface BatchConsumer<T> {
        public Awaitable accept(List<T> var1) throws Exception;
    }
}

