/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common;

import io.fluxcapacitor.common.Murmur3;
import java.util.function.Function;

public class ConsistentHashing {
    private static final Function<String, Integer> defaultHashFunction = Murmur3::murmurhash3_x86_32;

    public static int computeSegment(String routingKey) {
        return ConsistentHashing.computeSegment(routingKey, defaultHashFunction, 1024);
    }

    public static int computeSegment(String routingKey, int maxSegments) {
        return ConsistentHashing.computeSegment(routingKey, defaultHashFunction, maxSegments);
    }

    public static int computeSegment(String routingKey, Function<String, Integer> hashFunction, int segments) {
        return Math.abs(hashFunction.apply(routingKey)) % segments;
    }
}

