/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common;

import io.fluxcapacitor.common.reflection.ReflectionUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static void writeFile(String fileName, String content) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));){
            writer.write(content);
        }
    }

    public static String loadFile(String fileName) {
        return FileUtils.loadFile(ReflectionUtils.getCallerClass(), fileName, StandardCharsets.UTF_8);
    }

    public static String loadFile(Class<?> referencePoint, String fileName) {
        return FileUtils.loadFile(referencePoint, fileName, StandardCharsets.UTF_8);
    }

    public static String loadFile(String fileName, Charset charset) {
        return FileUtils.loadFile(ReflectionUtils.getCallerClass(), fileName, charset);
    }

    public static String loadFile(Class<?> referencePoint, String fileName, Charset charset) {
        String string;
        block10: {
            InputStream inputStream = referencePoint.getResourceAsStream(fileName);
            try {
                string = new Scanner(inputStream, charset.name()).useDelimiter("\\A").next();
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NullPointerException e) {
                    log.error("Resource {} not found in package {}", (Object)fileName, (Object)referencePoint.getPackageName());
                    throw e;
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static String loadFile(File file) {
        String string;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            string = new Scanner((InputStream)inputStream, StandardCharsets.UTF_8.name()).useDelimiter("\\A").next();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("File not found {}", (Object)file, (Object)e);
                throw e;
            }
        }
        ((InputStream)inputStream).close();
        return string;
    }
}

