/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common;

import io.fluxcapacitor.common.Pair;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ObjectUtils {
    private static final Predicate<Object> noOpPredicate = v -> true;
    private static final BiPredicate<Object, Object> noOpBiPredicate = (a, b) -> true;

    public static <T> Predicate<T> noOpPredicate() {
        return noOpPredicate;
    }

    public static <T, U> BiPredicate<T, U> noOpBiPredicate() {
        return noOpBiPredicate;
    }

    public static <T> Stream<T> iterate(T seed, UnaryOperator<T> f, Predicate<T> breakCondition) {
        return StreamSupport.stream(new BreakingSpliterator<T>(Stream.iterate(seed, f), breakCondition), false);
    }

    public static <T> List<T> deduplicate(List<T> list) {
        return ObjectUtils.deduplicate(list, UnaryOperator.identity());
    }

    public static <T> List<T> deduplicate(List<T> list, Function<T, ?> idFunction) {
        return ObjectUtils.deduplicate(list, idFunction, false);
    }

    public static <T> List<T> deduplicate(List<T> list, Function<T, ?> idFunction, boolean keepFirst) {
        list = new ArrayList<T>(list);
        HashSet ids = new HashSet();
        if (keepFirst) {
            list.removeIf(t -> !ids.add(idFunction.apply(t)));
        } else {
            ListIterator<T> iterator2 = list.listIterator(list.size());
            while (iterator2.hasPrevious()) {
                if (ids.add(idFunction.apply(iterator2.previous()))) continue;
                iterator2.remove();
            }
        }
        return list;
    }

    public static Stream<?> asStream(Object value) {
        if (value == null) {
            return Stream.empty();
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream();
        }
        if (value instanceof Stream) {
            return (Stream)value;
        }
        if (value instanceof Optional) {
            return ((Optional)value).stream();
        }
        return Stream.of(value);
    }

    public static <T> MemoizingSupplier<T> memoize(Supplier<T> supplier) {
        return new MemoizingSupplier<T>(supplier);
    }

    public static <K, V> MemoizingFunction<K, V> memoize(Function<K, V> supplier) {
        return new MemoizingFunction<K, V>(supplier);
    }

    public static <T, U, R> MemoizingBiFunction<T, U, R> memoize(BiFunction<T, U, R> supplier) {
        return new MemoizingBiFunction<T, U, R>(supplier);
    }

    public static Consumer<Runnable> ifTrue(boolean check) {
        if (check) {
            return Runnable::run;
        }
        return r -> {};
    }

    public static Object forceThrow(Throwable error) {
        throw error;
    }

    public static <T> T safelyCall(Callable<T> callable) {
        return callable.call();
    }

    public static <T> Supplier<T> safelySupply(Callable<T> callable) {
        return () -> ObjectUtils.safelyCall(callable);
    }

    public static Runnable asRunnable(Callable<?> callable) {
        return () -> ObjectUtils.safelyCall(callable);
    }

    public static Throwable unwrapException(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof CompletionException || e instanceof ExecutionException) {
            return ObjectUtils.unwrapException(e.getCause());
        }
        return e;
    }

    private static class BreakingSpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private final Iterator<T> delegate;
        private final Predicate<T> breakCondition;
        private boolean stopped;

        private BreakingSpliterator(Stream<T> delegate, Predicate<T> breakCondition) {
            super(Long.MAX_VALUE, 0);
            this.delegate = delegate.iterator();
            this.breakCondition = breakCondition;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.stopped) {
                return false;
            }
            T value = this.delegate.next();
            if (this.breakCondition.test(value)) {
                this.stopped = true;
            }
            action.accept(value);
            return true;
        }
    }

    public static class MemoizingSupplier<T>
    implements Supplier<T> {
        private final MemoizingFunction<Object, T> delegate;
        private final Object singleton = new Object();

        public MemoizingSupplier(Supplier<T> delegate) {
            this.delegate = new MemoizingFunction<Object, Object>(o -> delegate.get());
        }

        @Override
        public T get() {
            return this.delegate.apply(this.singleton);
        }

        public boolean isCached() {
            return this.delegate.isCached(this.singleton);
        }
    }

    public static class MemoizingFunction<K, V>
    implements Function<K, V> {
        private final Map<Object, Object> map = new ConcurrentHashMap<Object, Object>();
        private final Function<K, V> delegate;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V apply(K key) {
            NullObject storedKey = key == null ? NullObject.INSTANCE : key;
            Object v = this.map.get((Object)storedKey);
            if (v == null) {
                Function<K, V> function = this.delegate;
                synchronized (function) {
                    v = this.map.get((Object)storedKey);
                    if (v == null) {
                        v = this.map.computeIfAbsent((Object)storedKey, k -> Optional.ofNullable(this.delegate.apply(k == NullObject.INSTANCE ? null : key)).orElse((V)((Object)NullObject.INSTANCE)));
                    }
                }
            }
            return (V)(v == NullObject.INSTANCE ? null : v);
        }

        public boolean isCached(K key) {
            return key == null || this.map.containsKey(key);
        }

        @ConstructorProperties(value={"delegate"})
        public MemoizingFunction(Function<K, V> delegate) {
            this.delegate = delegate;
        }

        private static enum NullObject {
            INSTANCE;

        }
    }

    public static class MemoizingBiFunction<T, U, R>
    implements BiFunction<T, U, R> {
        private final MemoizingFunction<Pair<T, U>, R> function;

        public MemoizingBiFunction(BiFunction<T, U, R> delegate) {
            this.function = ObjectUtils.memoize(p -> delegate.apply(p.getFirst(), p.getSecond()));
        }

        @Override
        public R apply(T t, U u) {
            return this.function.apply(new Pair<T, U>(t, u));
        }

        public boolean isCached(T t, U u) {
            return this.function.isCached(new Pair<T, U>(t, u));
        }

        @ConstructorProperties(value={"function"})
        public MemoizingBiFunction(MemoizingFunction<Pair<T, U>, R> function) {
            this.function = function;
        }
    }
}

