/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class SearchUtils {
    public static final String letterOrNumber = "\\p{L}0-9";
    public static final Pattern termPattern = Pattern.compile(String.format("\"[^\"]*\"|[%1$s][^\\s]*[%1$s]|[%1$s]", "\\p{L}0-9"), 8);
    private static final Map<String, Pattern> globPatternCache = new ConcurrentHashMap<String, Pattern>();

    public static String normalize(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return StringUtils.stripAccents(text.trim().toLowerCase());
    }

    public static Pattern convertGlobToRegex(String pattern) {
        return globPatternCache.computeIfAbsent(pattern, p -> {
            StringBuilder sb = new StringBuilder(p.length());
            int inGroup = 0;
            int inClass = 0;
            int firstIndexInClass = -1;
            char[] arr = p.toCharArray();
            block16: for (int i = 0; i < arr.length; ++i) {
                char ch = arr[i];
                switch (ch) {
                    case '\\': {
                        if (++i >= arr.length) {
                            sb.append('\\');
                            continue block16;
                        }
                        char next = arr[i];
                        switch (next) {
                            case ',': {
                                break;
                            }
                            case 'E': 
                            case 'Q': {
                                sb.append('\\');
                            }
                            default: {
                                sb.append('\\');
                            }
                        }
                        sb.append(next);
                        continue block16;
                    }
                    case '*': {
                        if (inClass == 0) {
                            sb.append(".*");
                            continue block16;
                        }
                        sb.append('*');
                        continue block16;
                    }
                    case '?': {
                        if (inClass == 0) {
                            sb.append('.');
                            continue block16;
                        }
                        sb.append('?');
                        continue block16;
                    }
                    case '[': {
                        ++inClass;
                        firstIndexInClass = i + 1;
                        sb.append('[');
                        continue block16;
                    }
                    case ']': {
                        --inClass;
                        sb.append(']');
                        continue block16;
                    }
                    case '$': 
                    case '%': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '@': 
                    case '^': 
                    case '|': {
                        if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                            sb.append('\\');
                        }
                        sb.append(ch);
                        continue block16;
                    }
                    case '!': {
                        if (firstIndexInClass == i) {
                            sb.append('^');
                            continue block16;
                        }
                        sb.append('!');
                        continue block16;
                    }
                    case '{': {
                        ++inGroup;
                        sb.append('(');
                        continue block16;
                    }
                    case '}': {
                        --inGroup;
                        sb.append(')');
                        continue block16;
                    }
                    case ',': {
                        if (inGroup > 0) {
                            sb.append('|');
                            continue block16;
                        }
                        sb.append(',');
                        continue block16;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            return Pattern.compile(sb.toString());
        });
    }

    public static boolean isInteger(String fieldName) {
        if (StringUtils.isNumeric(fieldName)) {
            try {
                Integer.valueOf(fieldName);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static Object asIntegerOrString(String fieldName) {
        if (StringUtils.isNumeric(fieldName)) {
            try {
                return Integer.valueOf(fieldName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fieldName;
    }

    public static List<String> splitInTerms(String query) {
        ArrayList<String> parts = new ArrayList<String>();
        Matcher matcher = termPattern.matcher(query.trim());
        while (matcher.find()) {
            String group = matcher.group().trim();
            if (group.isEmpty() || group.equals("\"")) continue;
            if (group.startsWith("\"") && group.endsWith("\"")) {
                group = group.substring(1, group.length() - 1);
            }
            parts.add(group);
        }
        return parts;
    }
}

