/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api;

import io.fluxcapacitor.common.api.SerializedObject;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.function.Supplier;

public final class Data<T>
implements SerializedObject<T, Data<T>> {
    private final Supplier<T> value;
    private final String type;
    private final int revision;
    private final String format;

    @ConstructorProperties(value={"value", "type", "revision", "format"})
    public Data(T value, String type2, int revision, String format) {
        this.value = () -> value;
        this.type = type2;
        this.revision = revision;
        this.format = format;
    }

    public Data(T value, String type2, int revision) {
        this.value = () -> value;
        this.type = type2;
        this.revision = revision;
        this.format = null;
    }

    public Data(Supplier<T> value, String type2, int revision, String format) {
        this.value = value;
        this.type = type2;
        this.revision = revision;
        this.format = format;
    }

    public T getValue() {
        return this.value.get();
    }

    public String getFormat() {
        return this.format == null || "json".equals(this.format) ? "application/json" : this.format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Data data2 = (Data)o;
        return this.revision == data2.revision && Objects.deepEquals(this.getValue(), data2.getValue()) && Objects.equals(this.type, data2.type) && Objects.equals(this.getFormat(), data2.getFormat());
    }

    public int hashCode() {
        return Objects.hash(this.getValue(), this.type, this.revision, this.format);
    }

    @Override
    public Data<T> data() {
        return this;
    }

    @Override
    public Data<T> withData(Data<T> data2) {
        return data2;
    }

    public String getType() {
        return this.type;
    }

    public int getRevision() {
        return this.revision;
    }

    public String toString() {
        return "Data(type=" + this.getType() + ", revision=" + this.getRevision() + ", format=" + this.getFormat() + ")";
    }

    public Data<T> withType(String type2) {
        return this.type == type2 ? this : new Data<T>(this.value, type2, this.revision, this.format);
    }
}

