/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.fluxcapacitor.common.serialization.NullCollectionsAsEmptyModule;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class Metadata {
    public static JsonMapper objectMapper = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).addModule(new NullCollectionsAsEmptyModule())).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS)).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).build();
    private final Map<String, String> entries;

    @JsonAnyGetter
    public Map<String, String> getEntries() {
        return this.entries;
    }

    public static Metadata of(Object ... keyValues) {
        if (keyValues == null) {
            throw new NullPointerException("keyValues is marked non-null but is null");
        }
        return Metadata.empty().with(keyValues);
    }

    public static Metadata empty() {
        return new Metadata(Collections.emptyMap());
    }

    public static Metadata of(Object key, Object value) {
        return Metadata.empty().with(key, value);
    }

    public static Metadata of(Map<?, ?> map) {
        return Metadata.empty().with(map);
    }

    @JsonCreator
    private Metadata(Map<String, String> entries) {
        this.entries = entries;
    }

    public String toString() {
        return this.entries.toString();
    }

    public Metadata with(Map<?, ?> values2) {
        HashMap<String, String> map = new HashMap<String, String>(this.entries);
        values2.forEach((key, value) -> Metadata.with(key, value, map));
        return new Metadata(map);
    }

    public Metadata with(Metadata metadata2) {
        HashMap<String, String> map = new HashMap<String, String>(this.entries);
        map.putAll(metadata2.entries);
        return new Metadata(map);
    }

    public Metadata with(Object ... keyValues) {
        if (keyValues == null) {
            throw new NullPointerException("keyValues is marked non-null but is null");
        }
        if (keyValues.length % 2 == 1) {
            throw new IllegalArgumentException("Failed to create metadata for keys " + Arrays.toString(keyValues));
        }
        HashMap<String, String> map = new HashMap<String, String>(this.entries);
        for (int i = 0; i < keyValues.length; i += 2) {
            Metadata.with(keyValues[i].toString(), keyValues[i + 1], map);
        }
        return new Metadata(map);
    }

    public Metadata with(Object key, Object value) {
        return new Metadata(Metadata.with(key, value, new HashMap<String, String>(this.entries)));
    }

    public Metadata addIfAbsent(Object key, String value) {
        return this.containsKey(key) ? this : this.with(key, (Object)value);
    }

    private static Map<String, String> with(Object key, Object value, Map<String, String> entries) {
        String keyString = key.toString();
        if (value == null) {
            entries.remove(keyString);
            return entries;
        }
        if (value instanceof Optional) {
            Optional optional = (Optional)value;
            if (optional.isEmpty()) {
                return entries;
            }
            value = optional.get();
        }
        entries.put(keyString, value instanceof String ? (String)value : objectMapper.writeValueAsString(value));
        return entries;
    }

    private static Map<String, String> withTrace(Object key, Object value, Map<String, String> entries) {
        return Metadata.with("$trace." + key, value, entries);
    }

    public Metadata withTrace(Object key, Object value) {
        return new Metadata(Metadata.withTrace(key, value, new HashMap<String, String>(this.entries)));
    }

    public Metadata without(Object key) {
        HashMap<String, String> map = new HashMap<String, String>(this.entries);
        map.remove(key.toString());
        return new Metadata(map);
    }

    public Metadata withoutIf(Predicate<String> check) {
        HashMap<String, String> map = new HashMap<String, String>(this.entries);
        Iterator iterator2 = map.keySet().iterator();
        iterator2.forEachRemaining(key -> {
            if (check.test((String)key)) {
                iterator2.remove();
            }
        });
        return new Metadata(map);
    }

    public String get(Object key) {
        return this.entries.get(key.toString());
    }

    public <T> T get(Object key, Class<T> type2) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type2)) {
            return (T)value;
        }
        try {
            return objectMapper.readValue(value, type2);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to deserialize value %s to a %s for key %s", value, type2.getSimpleName(), key), e);
        }
    }

    @JsonIgnore
    public Map<String, String> getTraceEntries() {
        return this.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("$trace.")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean containsKey(Object key) {
        return this.entries.containsKey(key.toString());
    }

    public boolean containsAnyKey(Object ... keys2) {
        return Arrays.stream(keys2).anyMatch(this::containsKey);
    }

    public String getOrDefault(Object key, String defaultValue) {
        return this.entries.getOrDefault(key.toString(), defaultValue);
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.entries.entrySet();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Metadata)) {
            return false;
        }
        Metadata other = (Metadata)o;
        Map<String, String> this$entries = this.getEntries();
        Map<String, String> other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Map<String, String> $entries = this.getEntries();
        result2 = result2 * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result2;
    }
}

