/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.keyvalue;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.Command;
import io.fluxcapacitor.common.api.keyvalue.KeyValuePair;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;

public final class StoreValues
extends Command {
    private final List<KeyValuePair> values;
    private final Guarantee guarantee;

    @Override
    public Object toMetric() {
        return new Metric(this.values.stream().map(KeyValuePair::getKey).collect(Collectors.toList()), this.values.size());
    }

    public String toString() {
        return "StoreValues of size " + this.values.size();
    }

    @ConstructorProperties(value={"values", "guarantee"})
    public StoreValues(List<KeyValuePair> values2, Guarantee guarantee) {
        this.values = values2;
        this.guarantee = guarantee;
    }

    public List<KeyValuePair> getValues() {
        return this.values;
    }

    @Override
    public Guarantee getGuarantee() {
        return this.guarantee;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoreValues)) {
            return false;
        }
        StoreValues other = (StoreValues)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<KeyValuePair> this$values = this.getValues();
        List<KeyValuePair> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        Guarantee this$guarantee = this.getGuarantee();
        Guarantee other$guarantee = other.getGuarantee();
        return !(this$guarantee == null ? other$guarantee != null : !((Object)((Object)this$guarantee)).equals((Object)other$guarantee));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StoreValues;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result2 = super.hashCode();
        List<KeyValuePair> $values = this.getValues();
        result2 = result2 * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        Guarantee $guarantee = this.getGuarantee();
        result2 = result2 * 59 + ($guarantee == null ? 43 : ((Object)((Object)$guarantee)).hashCode());
        return result2;
    }

    public static final class Metric {
        private final List<String> keys;
        private final int size;

        @ConstructorProperties(value={"keys", "size"})
        public Metric(List<String> keys2, int size) {
            this.keys = keys2;
            this.size = size;
        }

        public List<String> getKeys() {
            return this.keys;
        }

        public int getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            List<String> this$keys = this.getKeys();
            List<String> other$keys = other.getKeys();
            return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            result2 = result2 * 59 + this.getSize();
            List<String> $keys = this.getKeys();
            result2 = result2 * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
            return result2;
        }

        public String toString() {
            return "StoreValues.Metric(keys=" + this.getKeys() + ", size=" + this.getSize() + ")";
        }
    }
}

