/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.publishing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.Command;
import io.fluxcapacitor.common.api.SerializedMessage;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;

public final class Append
extends Command {
    private final List<SerializedMessage> messages;
    private final Guarantee guarantee;

    @JsonIgnore
    public int getSize() {
        return this.messages.size();
    }

    @Override
    public Guarantee getGuarantee() {
        return Optional.ofNullable(this.guarantee).orElse(Guarantee.NONE);
    }

    public String toString() {
        return "Append of length " + this.messages.size();
    }

    @Override
    public Metric toMetric() {
        return new Metric(this.getSize(), this.getGuarantee());
    }

    @ConstructorProperties(value={"messages", "guarantee"})
    public Append(List<SerializedMessage> messages, Guarantee guarantee) {
        this.messages = messages;
        this.guarantee = guarantee;
    }

    public List<SerializedMessage> getMessages() {
        return this.messages;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Append)) {
            return false;
        }
        Append other = (Append)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<SerializedMessage> this$messages = this.getMessages();
        List<SerializedMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        Guarantee this$guarantee = this.getGuarantee();
        Guarantee other$guarantee = other.getGuarantee();
        return !(this$guarantee == null ? other$guarantee != null : !((Object)((Object)this$guarantee)).equals((Object)other$guarantee));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Append;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        List<SerializedMessage> $messages = this.getMessages();
        result2 = result2 * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        Guarantee $guarantee = this.getGuarantee();
        result2 = result2 * 59 + ($guarantee == null ? 43 : ((Object)((Object)$guarantee)).hashCode());
        return result2;
    }

    public static final class Metric {
        private final int size;
        private final Guarantee guarantee;

        @ConstructorProperties(value={"size", "guarantee"})
        public Metric(int size, Guarantee guarantee) {
            this.size = size;
            this.guarantee = guarantee;
        }

        public int getSize() {
            return this.size;
        }

        public Guarantee getGuarantee() {
            return this.guarantee;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            Guarantee this$guarantee = this.getGuarantee();
            Guarantee other$guarantee = other.getGuarantee();
            return !(this$guarantee == null ? other$guarantee != null : !((Object)((Object)this$guarantee)).equals((Object)other$guarantee));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            result2 = result2 * 59 + this.getSize();
            Guarantee $guarantee = this.getGuarantee();
            result2 = result2 * 59 + ($guarantee == null ? 43 : ((Object)((Object)$guarantee)).hashCode());
            return result2;
        }

        public String toString() {
            return "Append.Metric(size=" + this.getSize() + ", guarantee=" + this.getGuarantee() + ")";
        }
    }
}

