/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.scheduling;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.Command;
import io.fluxcapacitor.common.api.scheduling.SerializedSchedule;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;

public final class Schedule
extends Command {
    private final List<SerializedSchedule> messages;
    private final Guarantee guarantee;

    public String toString() {
        return "Schedule of size " + this.messages.size();
    }

    @Override
    public Object toMetric() {
        return new Metric(this.messages.stream().map(SerializedSchedule::toMetric).collect(Collectors.toList()), this.messages.size());
    }

    @ConstructorProperties(value={"messages", "guarantee"})
    public Schedule(List<SerializedSchedule> messages, Guarantee guarantee) {
        this.messages = messages;
        this.guarantee = guarantee;
    }

    public List<SerializedSchedule> getMessages() {
        return this.messages;
    }

    @Override
    public Guarantee getGuarantee() {
        return this.guarantee;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<SerializedSchedule> this$messages = this.getMessages();
        List<SerializedSchedule> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        Guarantee this$guarantee = this.getGuarantee();
        Guarantee other$guarantee = other.getGuarantee();
        return !(this$guarantee == null ? other$guarantee != null : !((Object)((Object)this$guarantee)).equals((Object)other$guarantee));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Schedule;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        List<SerializedSchedule> $messages = this.getMessages();
        result2 = result2 * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        Guarantee $guarantee = this.getGuarantee();
        result2 = result2 * 59 + ($guarantee == null ? 43 : ((Object)((Object)$guarantee)).hashCode());
        return result2;
    }

    public static final class Metric {
        private final List<SerializedSchedule.Metric> messages;
        private final int size;

        @ConstructorProperties(value={"messages", "size"})
        public Metric(List<SerializedSchedule.Metric> messages, int size) {
            this.messages = messages;
            this.size = size;
        }

        public List<SerializedSchedule.Metric> getMessages() {
            return this.messages;
        }

        public int getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            List<SerializedSchedule.Metric> this$messages = this.getMessages();
            List<SerializedSchedule.Metric> other$messages = other.getMessages();
            return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            result2 = result2 * 59 + this.getSize();
            List<SerializedSchedule.Metric> $messages = this.getMessages();
            result2 = result2 * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            return result2;
        }

        public String toString() {
            return "Schedule.Metric(messages=" + this.getMessages() + ", size=" + this.getSize() + ")";
        }
    }
}

