/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public final class DocumentStats {
    private final Map<String, FieldStats> fieldStats;
    private final Map<String, String> group;

    public static Comparator<DocumentStats> getComparator(List<String> groupBy) {
        return groupBy.stream().map(g -> Comparator.nullsLast(Comparator.comparing(d -> d.getGroup().get(g), Comparator.nullsLast(Comparator.naturalOrder())))).reduce(Comparator::thenComparing).orElse((a, b) -> 0);
    }

    public static DocumentStatsBuilder builder() {
        return new DocumentStatsBuilder();
    }

    public Map<String, FieldStats> getFieldStats() {
        return this.fieldStats;
    }

    public Map<String, String> getGroup() {
        return this.group;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentStats)) {
            return false;
        }
        DocumentStats other = (DocumentStats)o;
        Map<String, FieldStats> this$fieldStats = this.getFieldStats();
        Map<String, FieldStats> other$fieldStats = other.getFieldStats();
        if (this$fieldStats == null ? other$fieldStats != null : !((Object)this$fieldStats).equals(other$fieldStats)) {
            return false;
        }
        Map<String, String> this$group = this.getGroup();
        Map<String, String> other$group = other.getGroup();
        return !(this$group == null ? other$group != null : !((Object)this$group).equals(other$group));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Map<String, FieldStats> $fieldStats = this.getFieldStats();
        result2 = result2 * 59 + ($fieldStats == null ? 43 : ((Object)$fieldStats).hashCode());
        Map<String, String> $group = this.getGroup();
        result2 = result2 * 59 + ($group == null ? 43 : ((Object)$group).hashCode());
        return result2;
    }

    public String toString() {
        return "DocumentStats(fieldStats=" + this.getFieldStats() + ", group=" + this.getGroup() + ")";
    }

    @ConstructorProperties(value={"fieldStats", "group"})
    public DocumentStats(Map<String, FieldStats> fieldStats, Map<String, String> group) {
        this.fieldStats = fieldStats;
        this.group = group;
    }

    public static class DocumentStatsBuilder {
        private Map<String, FieldStats> fieldStats;
        private Map<String, String> group;

        DocumentStatsBuilder() {
        }

        public DocumentStatsBuilder fieldStats(Map<String, FieldStats> fieldStats) {
            this.fieldStats = fieldStats;
            return this;
        }

        public DocumentStatsBuilder group(Map<String, String> group) {
            this.group = group;
            return this;
        }

        public DocumentStats build() {
            return new DocumentStats(this.fieldStats, this.group);
        }

        public String toString() {
            return "DocumentStats.DocumentStatsBuilder(fieldStats=" + this.fieldStats + ", group=" + this.group + ")";
        }
    }

    public static final class FieldStats {
        private final long count;
        private final BigDecimal min;
        private final BigDecimal max;
        private final BigDecimal average;

        public static BigDecimal getAverage(List<@NonNull BigDecimal> bigDecimals) {
            BigDecimal sum = bigDecimals.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            return sum.divide(new BigDecimal(bigDecimals.size()), RoundingMode.HALF_UP);
        }

        @ConstructorProperties(value={"count", "min", "max", "average"})
        FieldStats(long count, BigDecimal min, BigDecimal max, BigDecimal average) {
            this.count = count;
            this.min = min;
            this.max = max;
            this.average = average;
        }

        public static FieldStatsBuilder builder() {
            return new FieldStatsBuilder();
        }

        public long getCount() {
            return this.count;
        }

        public BigDecimal getMin() {
            return this.min;
        }

        public BigDecimal getMax() {
            return this.max;
        }

        public BigDecimal getAverage() {
            return this.average;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldStats)) {
                return false;
            }
            FieldStats other = (FieldStats)o;
            if (this.getCount() != other.getCount()) {
                return false;
            }
            BigDecimal this$min = this.getMin();
            BigDecimal other$min = other.getMin();
            if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
                return false;
            }
            BigDecimal this$max = this.getMax();
            BigDecimal other$max = other.getMax();
            if (this$max == null ? other$max != null : !((Object)this$max).equals(other$max)) {
                return false;
            }
            BigDecimal this$average = this.getAverage();
            BigDecimal other$average = other.getAverage();
            return !(this$average == null ? other$average != null : !((Object)this$average).equals(other$average));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            long $count = this.getCount();
            result2 = result2 * 59 + (int)($count >>> 32 ^ $count);
            BigDecimal $min = this.getMin();
            result2 = result2 * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
            BigDecimal $max = this.getMax();
            result2 = result2 * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
            BigDecimal $average = this.getAverage();
            result2 = result2 * 59 + ($average == null ? 43 : ((Object)$average).hashCode());
            return result2;
        }

        public String toString() {
            return "DocumentStats.FieldStats(count=" + this.getCount() + ", min=" + this.getMin() + ", max=" + this.getMax() + ", average=" + this.getAverage() + ")";
        }

        public static class FieldStatsBuilder {
            private long count;
            private BigDecimal min;
            private BigDecimal max;
            private BigDecimal average;

            FieldStatsBuilder() {
            }

            public FieldStatsBuilder count(long count) {
                this.count = count;
                return this;
            }

            public FieldStatsBuilder min(BigDecimal min) {
                this.min = min;
                return this;
            }

            public FieldStatsBuilder max(BigDecimal max) {
                this.max = max;
                return this;
            }

            public FieldStatsBuilder average(BigDecimal average) {
                this.average = average;
                return this;
            }

            public FieldStats build() {
                return new FieldStats(this.count, this.min, this.max, this.average);
            }

            public String toString() {
                return "DocumentStats.FieldStats.FieldStatsBuilder(count=" + this.count + ", min=" + this.min + ", max=" + this.max + ", average=" + this.average + ")";
            }
        }
    }
}

