/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.Command;
import io.fluxcapacitor.common.api.search.SerializedDocument;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;

public final class IndexDocuments
extends Command {
    private final List<SerializedDocument> documents;
    private final boolean ifNotExists;
    private final Guarantee guarantee;

    @JsonIgnore
    public int getSize() {
        return this.documents.size();
    }

    public String toString() {
        return "IndexDocuments of length " + this.documents.size();
    }

    @Override
    public Metric toMetric() {
        return new Metric(this.getSize(), this.ifNotExists, this.guarantee, this.documents.stream().map(SerializedDocument::getId).collect(Collectors.toList()));
    }

    @ConstructorProperties(value={"documents", "ifNotExists", "guarantee"})
    public IndexDocuments(List<SerializedDocument> documents, boolean ifNotExists, Guarantee guarantee) {
        this.documents = documents;
        this.ifNotExists = ifNotExists;
        this.guarantee = guarantee;
    }

    public List<SerializedDocument> getDocuments() {
        return this.documents;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public Guarantee getGuarantee() {
        return this.guarantee;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexDocuments)) {
            return false;
        }
        IndexDocuments other = (IndexDocuments)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isIfNotExists() != other.isIfNotExists()) {
            return false;
        }
        List<SerializedDocument> this$documents = this.getDocuments();
        List<SerializedDocument> other$documents = other.getDocuments();
        if (this$documents == null ? other$documents != null : !((Object)this$documents).equals(other$documents)) {
            return false;
        }
        Guarantee this$guarantee = this.getGuarantee();
        Guarantee other$guarantee = other.getGuarantee();
        return !(this$guarantee == null ? other$guarantee != null : !((Object)((Object)this$guarantee)).equals((Object)other$guarantee));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IndexDocuments;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result2 = super.hashCode();
        result2 = result2 * 59 + (this.isIfNotExists() ? 79 : 97);
        List<SerializedDocument> $documents = this.getDocuments();
        result2 = result2 * 59 + ($documents == null ? 43 : ((Object)$documents).hashCode());
        Guarantee $guarantee = this.getGuarantee();
        result2 = result2 * 59 + ($guarantee == null ? 43 : ((Object)((Object)$guarantee)).hashCode());
        return result2;
    }

    public static final class Metric {
        private final int size;
        private final boolean ifNotExists;
        private final Guarantee guarantee;
        private final List<String> ids;

        @ConstructorProperties(value={"size", "ifNotExists", "guarantee", "ids"})
        public Metric(int size, boolean ifNotExists, Guarantee guarantee, List<String> ids) {
            this.size = size;
            this.ifNotExists = ifNotExists;
            this.guarantee = guarantee;
            this.ids = ids;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isIfNotExists() {
            return this.ifNotExists;
        }

        public Guarantee getGuarantee() {
            return this.guarantee;
        }

        public List<String> getIds() {
            return this.ids;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            if (this.isIfNotExists() != other.isIfNotExists()) {
                return false;
            }
            Guarantee this$guarantee = this.getGuarantee();
            Guarantee other$guarantee = other.getGuarantee();
            if (this$guarantee == null ? other$guarantee != null : !((Object)((Object)this$guarantee)).equals((Object)other$guarantee)) {
                return false;
            }
            List<String> this$ids = this.getIds();
            List<String> other$ids = other.getIds();
            return !(this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            result2 = result2 * 59 + this.getSize();
            result2 = result2 * 59 + (this.isIfNotExists() ? 79 : 97);
            Guarantee $guarantee = this.getGuarantee();
            result2 = result2 * 59 + ($guarantee == null ? 43 : ((Object)((Object)$guarantee)).hashCode());
            List<String> $ids = this.getIds();
            result2 = result2 * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
            return result2;
        }

        public String toString() {
            return "IndexDocuments.Metric(size=" + this.getSize() + ", ifNotExists=" + this.isIfNotExists() + ", guarantee=" + this.getGuarantee() + ", ids=" + this.getIds() + ")";
        }
    }
}

