/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search;

import io.fluxcapacitor.common.SearchUtils;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.common.api.search.SearchQuery;
import io.fluxcapacitor.common.api.search.SerializedDocument;
import io.fluxcapacitor.common.search.Document;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public final class SearchDocuments
extends Request {
    private final SearchQuery query;
    private final List<String> sorting;
    private final Integer maxSize;
    private final List<String> pathFilters;
    private final int skip;
    private final SerializedDocument lastHit;

    public Predicate<Document.Path> computePathFilter() {
        return this.pathFilters.stream().map(p -> {
            boolean negate = p.startsWith("-");
            p = negate ? p.substring(1) : p;
            Predicate<String> predicate = SearchUtils.convertGlobToRegex(p + "/**").asMatchPredicate().or(SearchUtils.convertGlobToRegex(p).asMatchPredicate());
            return negate ? predicate.negate() : predicate;
        }).reduce(Predicate::or).map(s -> p -> s.test(p.getValue())).orElse(p -> true);
    }

    private static List<String> $default$sorting() {
        return Collections.emptyList();
    }

    private static List<String> $default$pathFilters() {
        return Collections.emptyList();
    }

    @ConstructorProperties(value={"query", "sorting", "maxSize", "pathFilters", "skip", "lastHit"})
    SearchDocuments(SearchQuery query, List<String> sorting, Integer maxSize, List<String> pathFilters, int skip, SerializedDocument lastHit) {
        this.query = query;
        this.sorting = sorting;
        this.maxSize = maxSize;
        this.pathFilters = pathFilters;
        this.skip = skip;
        this.lastHit = lastHit;
    }

    public static SearchDocumentsBuilder builder() {
        return new SearchDocumentsBuilder();
    }

    public SearchDocumentsBuilder toBuilder() {
        return new SearchDocumentsBuilder().query(this.query).sorting(this.sorting).maxSize(this.maxSize).pathFilters(this.pathFilters).skip(this.skip).lastHit(this.lastHit);
    }

    public SearchQuery getQuery() {
        return this.query;
    }

    public List<String> getSorting() {
        return this.sorting;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public List<String> getPathFilters() {
        return this.pathFilters;
    }

    public int getSkip() {
        return this.skip;
    }

    public SerializedDocument getLastHit() {
        return this.lastHit;
    }

    public String toString() {
        return "SearchDocuments(query=" + this.getQuery() + ", sorting=" + this.getSorting() + ", maxSize=" + this.getMaxSize() + ", pathFilters=" + this.getPathFilters() + ", skip=" + this.getSkip() + ", lastHit=" + this.getLastHit() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchDocuments)) {
            return false;
        }
        SearchDocuments other = (SearchDocuments)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSkip() != other.getSkip()) {
            return false;
        }
        Integer this$maxSize = this.getMaxSize();
        Integer other$maxSize = other.getMaxSize();
        if (this$maxSize == null ? other$maxSize != null : !((Object)this$maxSize).equals(other$maxSize)) {
            return false;
        }
        SearchQuery this$query = this.getQuery();
        SearchQuery other$query = other.getQuery();
        if (this$query == null ? other$query != null : !((Object)this$query).equals(other$query)) {
            return false;
        }
        List<String> this$sorting = this.getSorting();
        List<String> other$sorting = other.getSorting();
        if (this$sorting == null ? other$sorting != null : !((Object)this$sorting).equals(other$sorting)) {
            return false;
        }
        List<String> this$pathFilters = this.getPathFilters();
        List<String> other$pathFilters = other.getPathFilters();
        if (this$pathFilters == null ? other$pathFilters != null : !((Object)this$pathFilters).equals(other$pathFilters)) {
            return false;
        }
        SerializedDocument this$lastHit = this.getLastHit();
        SerializedDocument other$lastHit = other.getLastHit();
        return !(this$lastHit == null ? other$lastHit != null : !((Object)this$lastHit).equals(other$lastHit));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SearchDocuments;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result2 = super.hashCode();
        result2 = result2 * 59 + this.getSkip();
        Integer $maxSize = this.getMaxSize();
        result2 = result2 * 59 + ($maxSize == null ? 43 : ((Object)$maxSize).hashCode());
        SearchQuery $query = this.getQuery();
        result2 = result2 * 59 + ($query == null ? 43 : ((Object)$query).hashCode());
        List<String> $sorting = this.getSorting();
        result2 = result2 * 59 + ($sorting == null ? 43 : ((Object)$sorting).hashCode());
        List<String> $pathFilters = this.getPathFilters();
        result2 = result2 * 59 + ($pathFilters == null ? 43 : ((Object)$pathFilters).hashCode());
        SerializedDocument $lastHit = this.getLastHit();
        result2 = result2 * 59 + ($lastHit == null ? 43 : ((Object)$lastHit).hashCode());
        return result2;
    }

    public static class SearchDocumentsBuilder {
        private SearchQuery query;
        private boolean sorting$set;
        private List<String> sorting$value;
        private Integer maxSize;
        private boolean pathFilters$set;
        private List<String> pathFilters$value;
        private int skip;
        private SerializedDocument lastHit;

        SearchDocumentsBuilder() {
        }

        public SearchDocumentsBuilder query(SearchQuery query) {
            this.query = query;
            return this;
        }

        public SearchDocumentsBuilder sorting(List<String> sorting) {
            this.sorting$value = sorting;
            this.sorting$set = true;
            return this;
        }

        public SearchDocumentsBuilder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public SearchDocumentsBuilder pathFilters(List<String> pathFilters) {
            this.pathFilters$value = pathFilters;
            this.pathFilters$set = true;
            return this;
        }

        public SearchDocumentsBuilder skip(int skip) {
            this.skip = skip;
            return this;
        }

        public SearchDocumentsBuilder lastHit(SerializedDocument lastHit) {
            this.lastHit = lastHit;
            return this;
        }

        public SearchDocuments build() {
            List<String> sorting$value = this.sorting$value;
            if (!this.sorting$set) {
                sorting$value = SearchDocuments.$default$sorting();
            }
            List<String> pathFilters$value = this.pathFilters$value;
            if (!this.pathFilters$set) {
                pathFilters$value = SearchDocuments.$default$pathFilters();
            }
            return new SearchDocuments(this.query, sorting$value, this.maxSize, pathFilters$value, this.skip, this.lastHit);
        }

        public String toString() {
            return "SearchDocuments.SearchDocumentsBuilder(query=" + this.query + ", sorting$value=" + this.sorting$value + ", maxSize=" + this.maxSize + ", pathFilters$value=" + this.pathFilters$value + ", skip=" + this.skip + ", lastHit=" + this.lastHit + ")";
        }
    }
}

