/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fluxcapacitor.common.api.search.Constraint;
import io.fluxcapacitor.common.api.search.constraints.AllConstraint;
import io.fluxcapacitor.common.search.Document;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public final class SearchQuery {
    @JsonProperty(value="collection")
    private final List<String> collections;
    private final Instant since;
    private final Instant before;
    private final boolean requireTimestamp;
    private final List<Constraint> constraints;
    private final AtomicReference<Object> decomposeConstraints = new AtomicReference();

    public boolean matches(Document d) {
        if (!this.decomposeConstraints().matches(d)) {
            return false;
        }
        if (this.requireTimestamp && d.getEnd() == null && d.getTimestamp() == null) {
            return false;
        }
        if (this.since != null && d.getEnd() != null && d.getEnd().compareTo(this.since) < 0) {
            return false;
        }
        if (this.before != null && d.getTimestamp() != null && d.getTimestamp().compareTo(this.before) >= 0) {
            return false;
        }
        return this.collections.isEmpty() || this.collections.contains(d.getCollection());
    }

    @ConstructorProperties(value={"collections", "since", "before", "requireTimestamp", "constraints"})
    SearchQuery(List<String> collections, Instant since, Instant before, boolean requireTimestamp, List<Constraint> constraints) {
        this.collections = collections;
        this.since = since;
        this.before = before;
        this.requireTimestamp = requireTimestamp;
        this.constraints = constraints;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder().since(this.since).before(this.before).requireTimestamp(this.requireTimestamp);
        if (this.collections != null) {
            builder.collections(this.collections);
        }
        if (this.constraints != null) {
            builder.constraints(this.constraints);
        }
        return builder;
    }

    public List<String> getCollections() {
        return this.collections;
    }

    public Instant getSince() {
        return this.since;
    }

    public Instant getBefore() {
        return this.before;
    }

    public boolean isRequireTimestamp() {
        return this.requireTimestamp;
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchQuery)) {
            return false;
        }
        SearchQuery other = (SearchQuery)o;
        if (this.isRequireTimestamp() != other.isRequireTimestamp()) {
            return false;
        }
        List<String> this$collections = this.getCollections();
        List<String> other$collections = other.getCollections();
        if (this$collections == null ? other$collections != null : !((Object)this$collections).equals(other$collections)) {
            return false;
        }
        Instant this$since = this.getSince();
        Instant other$since = other.getSince();
        if (this$since == null ? other$since != null : !((Object)this$since).equals(other$since)) {
            return false;
        }
        Instant this$before = this.getBefore();
        Instant other$before = other.getBefore();
        if (this$before == null ? other$before != null : !((Object)this$before).equals(other$before)) {
            return false;
        }
        List<Constraint> this$constraints = this.getConstraints();
        List<Constraint> other$constraints = other.getConstraints();
        return !(this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + (this.isRequireTimestamp() ? 79 : 97);
        List<String> $collections = this.getCollections();
        result2 = result2 * 59 + ($collections == null ? 43 : ((Object)$collections).hashCode());
        Instant $since = this.getSince();
        result2 = result2 * 59 + ($since == null ? 43 : ((Object)$since).hashCode());
        Instant $before = this.getBefore();
        result2 = result2 * 59 + ($before == null ? 43 : ((Object)$before).hashCode());
        List<Constraint> $constraints = this.getConstraints();
        result2 = result2 * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
        return result2;
    }

    public String toString() {
        return "SearchQuery(collections=" + this.getCollections() + ", since=" + this.getSince() + ", before=" + this.getBefore() + ", requireTimestamp=" + this.isRequireTimestamp() + ", constraints=" + this.getConstraints() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint decomposeConstraints() {
        Object value = this.decomposeConstraints.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.decomposeConstraints;
            synchronized (atomicReference) {
                value = this.decomposeConstraints.get();
                if (value == null) {
                    Constraint actualValue = AllConstraint.all(this.getConstraints().stream().map(Constraint::decompose).collect(Collectors.toList()));
                    value = actualValue == null ? this.decomposeConstraints : actualValue;
                    this.decomposeConstraints.set(value);
                }
            }
        }
        return (Constraint)(value == this.decomposeConstraints ? null : value);
    }

    public static class Builder {
        private ArrayList<String> collections;
        private Instant since;
        private Instant before;
        private boolean requireTimestamp;
        private ArrayList<Constraint> constraints;

        Builder() {
        }

        public Builder collection(String collection) {
            if (this.collections == null) {
                this.collections = new ArrayList();
            }
            this.collections.add(collection);
            return this;
        }

        @JsonProperty(value="collection")
        public Builder collections(Collection<? extends String> collections) {
            if (collections == null) {
                throw new NullPointerException("collections cannot be null");
            }
            if (this.collections == null) {
                this.collections = new ArrayList();
            }
            this.collections.addAll(collections);
            return this;
        }

        public Builder clearCollections() {
            if (this.collections != null) {
                this.collections.clear();
            }
            return this;
        }

        public Builder since(Instant since) {
            this.since = since;
            return this;
        }

        public Builder before(Instant before) {
            this.before = before;
            return this;
        }

        public Builder requireTimestamp(boolean requireTimestamp) {
            this.requireTimestamp = requireTimestamp;
            return this;
        }

        public Builder constraint(Constraint constraint) {
            if (this.constraints == null) {
                this.constraints = new ArrayList();
            }
            this.constraints.add(constraint);
            return this;
        }

        public Builder constraints(Collection<? extends Constraint> constraints) {
            if (constraints == null) {
                throw new NullPointerException("constraints cannot be null");
            }
            if (this.constraints == null) {
                this.constraints = new ArrayList();
            }
            this.constraints.addAll(constraints);
            return this;
        }

        public Builder clearConstraints() {
            if (this.constraints != null) {
                this.constraints.clear();
            }
            return this;
        }

        public SearchQuery build() {
            List<Constraint> constraints;
            List<String> collections;
            switch (this.collections == null ? 0 : this.collections.size()) {
                case 0: {
                    collections = Collections.emptyList();
                    break;
                }
                case 1: {
                    collections = Collections.singletonList(this.collections.get(0));
                    break;
                }
                default: {
                    collections = Collections.unmodifiableList(new ArrayList<String>(this.collections));
                }
            }
            switch (this.constraints == null ? 0 : this.constraints.size()) {
                case 0: {
                    constraints = Collections.emptyList();
                    break;
                }
                case 1: {
                    constraints = Collections.singletonList(this.constraints.get(0));
                    break;
                }
                default: {
                    constraints = Collections.unmodifiableList(new ArrayList<Constraint>(this.constraints));
                }
            }
            return new SearchQuery(collections, this.since, this.before, this.requireTimestamp, constraints);
        }

        public String toString() {
            return "SearchQuery.Builder(collections=" + this.collections + ", since=" + this.since + ", before=" + this.before + ", requireTimestamp=" + this.requireTimestamp + ", constraints=" + this.constraints + ")";
        }
    }
}

