/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search;

import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.search.DefaultDocumentSerializer;
import io.fluxcapacitor.common.search.Document;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public final class SerializedDocument {
    private final String id;
    private final Long timestamp;
    private final Long end;
    private final String collection;
    private final Data<byte[]> document;
    private final String summary;
    private final AtomicReference<Object> deserializeDocument = new AtomicReference();

    public SerializedDocument(Document document) {
        this.id = document.getId();
        this.timestamp = Optional.ofNullable(document.getTimestamp()).map(Instant::toEpochMilli).orElse(null);
        this.end = Optional.ofNullable(document.getEnd()).map(Instant::toEpochMilli).orElse(null);
        this.collection = document.getCollection();
        this.document = DefaultDocumentSerializer.INSTANCE.serialize(document);
        this.summary = document.summarize();
    }

    public static SerializedDocumentBuilder builder() {
        return new SerializedDocumentBuilder();
    }

    public SerializedDocumentBuilder toBuilder() {
        return new SerializedDocumentBuilder().id(this.id).timestamp(this.timestamp).end(this.end).collection(this.collection).document(this.document).summary(this.summary);
    }

    public String getId() {
        return this.id;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Long getEnd() {
        return this.end;
    }

    public String getCollection() {
        return this.collection;
    }

    public Data<byte[]> getDocument() {
        return this.document;
    }

    public String getSummary() {
        return this.summary;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializedDocument)) {
            return false;
        }
        SerializedDocument other = (SerializedDocument)o;
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Long this$end = this.getEnd();
        Long other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$collection = this.getCollection();
        String other$collection = other.getCollection();
        if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
            return false;
        }
        Data<byte[]> this$document = this.getDocument();
        Data<byte[]> other$document = other.getDocument();
        if (this$document == null ? other$document != null : !((Object)this$document).equals(other$document)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        return !(this$summary == null ? other$summary != null : !this$summary.equals(other$summary));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Long $timestamp = this.getTimestamp();
        result2 = result2 * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Long $end = this.getEnd();
        result2 = result2 * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        String $id = this.getId();
        result2 = result2 * 59 + ($id == null ? 43 : $id.hashCode());
        String $collection = this.getCollection();
        result2 = result2 * 59 + ($collection == null ? 43 : $collection.hashCode());
        Data<byte[]> $document = this.getDocument();
        result2 = result2 * 59 + ($document == null ? 43 : ((Object)$document).hashCode());
        String $summary = this.getSummary();
        result2 = result2 * 59 + ($summary == null ? 43 : $summary.hashCode());
        return result2;
    }

    public String toString() {
        return "SerializedDocument(id=" + this.getId() + ", timestamp=" + this.getTimestamp() + ", end=" + this.getEnd() + ", collection=" + this.getCollection() + ", document=" + this.getDocument() + ", summary=" + this.getSummary() + ")";
    }

    @ConstructorProperties(value={"id", "timestamp", "end", "collection", "document", "summary"})
    public SerializedDocument(String id, Long timestamp, Long end, String collection, Data<byte[]> document, String summary) {
        this.id = id;
        this.timestamp = timestamp;
        this.end = end;
        this.collection = collection;
        this.document = document;
        this.summary = summary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document deserializeDocument() {
        Object value = this.deserializeDocument.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.deserializeDocument;
            synchronized (atomicReference) {
                value = this.deserializeDocument.get();
                if (value == null) {
                    Document actualValue = DefaultDocumentSerializer.INSTANCE.deserialize(this.getDocument());
                    value = actualValue == null ? this.deserializeDocument : actualValue;
                    this.deserializeDocument.set(value);
                }
            }
        }
        return (Document)(value == this.deserializeDocument ? null : value);
    }

    public static class SerializedDocumentBuilder {
        private String id;
        private Long timestamp;
        private Long end;
        private String collection;
        private Data<byte[]> document;
        private String summary;

        SerializedDocumentBuilder() {
        }

        public SerializedDocumentBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SerializedDocumentBuilder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SerializedDocumentBuilder end(Long end) {
            this.end = end;
            return this;
        }

        public SerializedDocumentBuilder collection(String collection) {
            this.collection = collection;
            return this;
        }

        public SerializedDocumentBuilder document(Data<byte[]> document) {
            this.document = document;
            return this;
        }

        public SerializedDocumentBuilder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public SerializedDocument build() {
            return new SerializedDocument(this.id, this.timestamp, this.end, this.collection, this.document, this.summary);
        }

        public String toString() {
            return "SerializedDocument.SerializedDocumentBuilder(id=" + this.id + ", timestamp=" + this.timestamp + ", end=" + this.end + ", collection=" + this.collection + ", document=" + this.document + ", summary=" + this.summary + ")";
        }
    }
}

