/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search.constraints;

import io.fluxcapacitor.common.api.search.constraints.PathConstraint;
import io.fluxcapacitor.common.search.Document;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import lombok.NonNull;

public final class BetweenConstraint
extends PathConstraint {
    private final String min;
    private final String max;
    private final List<String> paths;
    private final AtomicReference<Object> matcher = new AtomicReference();

    public static BetweenConstraint between(Object min, Object maxExclusive, @NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new BetweenConstraint(min == null ? null : min.toString(), maxExclusive == null ? null : maxExclusive.toString(), List.of(path));
    }

    public static BetweenConstraint atLeast(@NonNull Object min, @NonNull String path) {
        if (min == null) {
            throw new NullPointerException("min is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new BetweenConstraint(min.toString(), null, List.of(path));
    }

    public static BetweenConstraint below(@NonNull Object maxExclusive, @NonNull String path) {
        if (maxExclusive == null) {
            throw new NullPointerException("maxExclusive is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new BetweenConstraint(null, maxExclusive.toString(), List.of(path));
    }

    @Override
    protected boolean matches(Document.Entry entry) {
        return this.matcher().test(entry.getValue());
    }

    @Override
    protected boolean checkPathBeforeEntry() {
        return true;
    }

    public String getMin() {
        return this.min;
    }

    public String getMax() {
        return this.max;
    }

    @Override
    public List<String> getPaths() {
        return this.paths;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BetweenConstraint)) {
            return false;
        }
        BetweenConstraint other = (BetweenConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$min = this.getMin();
        String other$min = other.getMin();
        if (this$min == null ? other$min != null : !this$min.equals(other$min)) {
            return false;
        }
        String this$max = this.getMax();
        String other$max = other.getMax();
        if (this$max == null ? other$max != null : !this$max.equals(other$max)) {
            return false;
        }
        List<String> this$paths = this.getPaths();
        List<String> other$paths = other.getPaths();
        return !(this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BetweenConstraint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $min = this.getMin();
        result2 = result2 * 59 + ($min == null ? 43 : $min.hashCode());
        String $max = this.getMax();
        result2 = result2 * 59 + ($max == null ? 43 : $max.hashCode());
        List<String> $paths = this.getPaths();
        result2 = result2 * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        return result2;
    }

    public String toString() {
        return "BetweenConstraint(min=" + this.getMin() + ", max=" + this.getMax() + ", paths=" + this.getPaths() + ", matcher=" + this.matcher() + ")";
    }

    @ConstructorProperties(value={"min", "max", "paths"})
    private BetweenConstraint(String min, String max, List<String> paths) {
        this.min = min;
        this.max = max;
        this.paths = paths;
    }

    @Override
    public BetweenConstraint withPaths(List<String> paths) {
        return this.paths == paths ? this : new BetweenConstraint(this.min, this.max, paths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Predicate<String> matcher() {
        Object value = this.matcher.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.matcher;
            synchronized (atomicReference) {
                value = this.matcher.get();
                if (value == null) {
                    Predicate<String> actualValue = this.min == null ? (this.max == null ? s -> true : s -> s.compareTo(this.max) < 0) : (this.max == null ? s -> s.compareTo(this.min) >= 0 : s -> s.compareTo(this.min) >= 0 && s.compareTo(this.max) < 0);
                    value = actualValue == null ? this.matcher : actualValue;
                    this.matcher.set(value);
                }
            }
        }
        return (Predicate)(value == this.matcher ? null : value);
    }
}

