/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search.constraints;

import io.fluxcapacitor.common.SearchUtils;
import io.fluxcapacitor.common.api.search.Constraint;
import io.fluxcapacitor.common.api.search.NoOpConstraint;
import io.fluxcapacitor.common.api.search.constraints.AllConstraint;
import io.fluxcapacitor.common.api.search.constraints.PathConstraint;
import io.fluxcapacitor.common.search.Document;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class ContainsConstraint
extends PathConstraint {
    @NonNull
    private final String contains;
    private final List<String> paths;
    private final boolean prefixSearch;
    private final boolean postfixSearch;
    private final AtomicReference<Object> pattern = new AtomicReference();

    public static Constraint contains(String phrase, boolean prefixSearch, boolean postfixSearch, String ... paths) {
        return ContainsConstraint.contains(phrase, prefixSearch, postfixSearch, false, paths);
    }

    public static Constraint contains(String phrase, boolean prefixSearch, boolean postfixSearch, boolean splitInTerms, String ... paths) {
        return phrase == null ? NoOpConstraint.instance : AllConstraint.all((splitInTerms ? SearchUtils.splitInTerms(SearchUtils.normalize(phrase)) : List.of(SearchUtils.normalize(phrase))).stream().map(term -> new ContainsConstraint((String)term, List.of(paths), prefixSearch, postfixSearch)).collect(Collectors.toList()));
    }

    @Override
    protected boolean matches(Document.Entry entry) {
        return this.pattern().matcher(entry.asPhrase()).find();
    }

    @NonNull
    public String getContains() {
        return this.contains;
    }

    @Override
    public List<String> getPaths() {
        return this.paths;
    }

    public boolean isPrefixSearch() {
        return this.prefixSearch;
    }

    public boolean isPostfixSearch() {
        return this.postfixSearch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainsConstraint)) {
            return false;
        }
        ContainsConstraint other = (ContainsConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPrefixSearch() != other.isPrefixSearch()) {
            return false;
        }
        if (this.isPostfixSearch() != other.isPostfixSearch()) {
            return false;
        }
        String this$contains = this.getContains();
        String other$contains = other.getContains();
        if (this$contains == null ? other$contains != null : !this$contains.equals(other$contains)) {
            return false;
        }
        List<String> this$paths = this.getPaths();
        List<String> other$paths = other.getPaths();
        return !(this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContainsConstraint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + (this.isPrefixSearch() ? 79 : 97);
        result2 = result2 * 59 + (this.isPostfixSearch() ? 79 : 97);
        String $contains = this.getContains();
        result2 = result2 * 59 + ($contains == null ? 43 : $contains.hashCode());
        List<String> $paths = this.getPaths();
        result2 = result2 * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        return result2;
    }

    public String toString() {
        return "ContainsConstraint(contains=" + this.getContains() + ", paths=" + this.getPaths() + ", prefixSearch=" + this.isPrefixSearch() + ", postfixSearch=" + this.isPostfixSearch() + ", pattern=" + this.pattern() + ")";
    }

    @ConstructorProperties(value={"contains", "paths", "prefixSearch", "postfixSearch"})
    private ContainsConstraint(@NonNull String contains, List<String> paths, boolean prefixSearch, boolean postfixSearch) {
        if (contains == null) {
            throw new NullPointerException("contains is marked non-null but is null");
        }
        this.contains = contains;
        this.paths = paths;
        this.prefixSearch = prefixSearch;
        this.postfixSearch = postfixSearch;
    }

    @Override
    public ContainsConstraint withPaths(List<String> paths) {
        return this.paths == paths ? this : new ContainsConstraint(this.contains, paths, this.prefixSearch, this.postfixSearch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pattern pattern() {
        Object value = this.pattern.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.pattern;
            synchronized (atomicReference) {
                value = this.pattern.get();
                if (value == null) {
                    Pattern actualValue = Pattern.compile((this.prefixSearch ? "" : String.format("(?<=[^%s]|\\A)", "\\p{L}0-9")) + Pattern.quote(SearchUtils.normalize(this.contains)) + (this.postfixSearch ? "" : String.format("(?=[^%s]|\\Z)", "\\p{L}0-9")));
                    value = actualValue == null ? this.pattern : actualValue;
                    this.pattern.set(value);
                }
            }
        }
        return (Pattern)(value == this.pattern ? null : value);
    }
}

