/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search.constraints;

import io.fluxcapacitor.common.api.search.Constraint;
import io.fluxcapacitor.common.api.search.NoOpConstraint;
import io.fluxcapacitor.common.api.search.constraints.AllConstraint;
import io.fluxcapacitor.common.api.search.constraints.ContainsConstraint;
import io.fluxcapacitor.common.api.search.constraints.NotConstraint;
import io.fluxcapacitor.common.api.search.constraints.PathConstraint;
import io.fluxcapacitor.common.search.Document;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class QueryConstraint
extends PathConstraint {
    private static final String operator = "&|()!";
    private static final Pattern termPattern = Pattern.compile(String.format("\"[^\"]*\"|[%1$s]|[*%2$s][^\\s%1$s]+[*%2$s]|[*%2$s]+", "&|()!", "\\p{L}0-9"), 8);
    private static final Pattern splitOnInnerAsterisk = Pattern.compile(String.format("(?<=[%1$s])\\*(?=[%1$s])", "\\p{L}0-9"));
    @NonNull
    private final String query;
    private final List<String> paths;
    private final AtomicReference<Object> decompose = new AtomicReference();

    public static Constraint query(String query, String ... paths) {
        return StringUtils.isBlank(query) ? NoOpConstraint.instance : new QueryConstraint(query, List.of(paths));
    }

    @Override
    public boolean matches(Document document) {
        return this.decompose().matches(document);
    }

    @Override
    protected boolean matches(Document.Entry entry) {
        throw new UnsupportedOperationException();
    }

    private List<Constraint> createConstraints(List<String> parts) {
        ArrayList<Constraint> result2 = new ArrayList<Constraint>();
        ListIterator<String> iterator2 = parts.listIterator();
        while (iterator2.hasNext()) {
            this.parsePart(iterator2.next(), iterator2, result2);
        }
        return result2;
    }

    private void parsePart(String part, ListIterator<String> iterator2, List<Constraint> constraints) {
        switch (part) {
            case "(": {
                this.handleGroupStart(iterator2, constraints);
                break;
            }
            case "|": {
                this.handleOr(iterator2, constraints);
                break;
            }
            case "!": {
                this.handleNot(iterator2, constraints);
                break;
            }
            case "": {
                break;
            }
            default: {
                this.handleTerm(part, constraints);
            }
        }
    }

    private void handleGroupStart(ListIterator<String> iterator2, List<Constraint> constraints) {
        String part;
        ArrayList<Constraint> subList = new ArrayList<Constraint>();
        while (iterator2.hasNext() && !(part = iterator2.next()).equals(")")) {
            this.parsePart(part, iterator2, subList);
        }
        constraints.add(AllConstraint.all(subList));
    }

    private void handleOr(ListIterator<String> iterator2, List<Constraint> constraints) {
        if (iterator2.hasNext() && !constraints.isEmpty()) {
            Constraint leftHandConstraint = constraints.remove(constraints.size() - 1);
            ArrayList<Constraint> rightHandPart = new ArrayList<Constraint>();
            this.parsePart(iterator2.next(), iterator2, rightHandPart);
            constraints.add(leftHandConstraint.or(AllConstraint.all(rightHandPart)));
        } else {
            this.parsePart("OR", iterator2, constraints);
        }
    }

    private void handleNot(ListIterator<String> iterator2, List<Constraint> constraints) {
        ArrayList<Constraint> subList = new ArrayList<Constraint>();
        if (iterator2.hasNext()) {
            this.parsePart(iterator2.next(), iterator2, subList);
        }
        constraints.add(NotConstraint.not(AllConstraint.all(subList)));
    }

    private void handleTerm(String term, List<Constraint> constraints) {
        if (term.startsWith("\"") && term.endsWith("\"")) {
            constraints.add(ContainsConstraint.contains(term.substring(1, term.length() - 1), false, false, (String[])this.paths.toArray(String[]::new)));
            return;
        }
        ArrayList<Constraint> result2 = new ArrayList<Constraint>();
        String[] parts = splitOnInnerAsterisk.split(term);
        for (int i = 0; i < parts.length; ++i) {
            boolean prefixSearch = i != 0;
            boolean postfixSearch = i != parts.length - 1;
            String part = parts[i];
            if (part.endsWith("*")) {
                part = part.substring(0, part.length() - 1);
                postfixSearch = true;
            }
            if (part.startsWith("*")) {
                part = part.substring(1);
                prefixSearch = true;
            }
            result2.add(ContainsConstraint.contains(part, prefixSearch, postfixSearch, (String[])this.paths.toArray(String[]::new)));
        }
        constraints.add(AllConstraint.all(result2));
    }

    private List<String> splitInTermsAndOperators(String query) {
        ArrayList<String> parts = new ArrayList<String>();
        Matcher matcher = termPattern.matcher(query.trim());
        while (matcher.find()) {
            String group = matcher.group().trim();
            if (group.isEmpty() || group.equals("\"") || group.equals("AND") || group.equals("&")) continue;
            parts.add(group.equals("OR") ? "|" : group);
        }
        return parts;
    }

    @NonNull
    public String getQuery() {
        return this.query;
    }

    @Override
    public List<String> getPaths() {
        return this.paths;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryConstraint)) {
            return false;
        }
        QueryConstraint other = (QueryConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        List<String> this$paths = this.getPaths();
        List<String> other$paths = other.getPaths();
        return !(this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryConstraint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $query = this.getQuery();
        result2 = result2 * 59 + ($query == null ? 43 : $query.hashCode());
        List<String> $paths = this.getPaths();
        result2 = result2 * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        return result2;
    }

    public String toString() {
        return "QueryConstraint(query=" + this.getQuery() + ", paths=" + this.getPaths() + ")";
    }

    @ConstructorProperties(value={"query", "paths"})
    private QueryConstraint(@NonNull String query, List<String> paths) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        this.query = query;
        this.paths = paths;
    }

    @Override
    public QueryConstraint withPaths(List<String> paths) {
        return this.paths == paths ? this : new QueryConstraint(this.query, paths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constraint decompose() {
        Object value = this.decompose.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.decompose;
            synchronized (atomicReference) {
                value = this.decompose.get();
                if (value == null) {
                    Constraint actualValue = AllConstraint.all(this.createConstraints(this.splitInTermsAndOperators(this.getQuery())));
                    value = actualValue == null ? this.decompose : actualValue;
                    this.decompose.set(value);
                }
            }
        }
        return (Constraint)(value == this.decompose ? null : value);
    }
}

