/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.tracking;

import io.fluxcapacitor.common.api.QueryResult;
import io.fluxcapacitor.common.api.tracking.Position;
import java.beans.ConstructorProperties;
import java.util.Arrays;

public final class ClaimSegmentResult
implements QueryResult {
    private final long requestId;
    private final Position position;
    private final int[] segment;
    private final long timestamp = System.currentTimeMillis();

    @Override
    public Object toMetric() {
        return new Metric(this.requestId, this.position.lowestIndexForSegment(this.segment).orElse(null), this.segment, this.timestamp);
    }

    @ConstructorProperties(value={"requestId", "position", "segment"})
    public ClaimSegmentResult(long requestId, Position position, int[] segment) {
        this.requestId = requestId;
        this.position = position;
        this.segment = segment;
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    public Position getPosition() {
        return this.position;
    }

    public int[] getSegment() {
        return this.segment;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClaimSegmentResult)) {
            return false;
        }
        ClaimSegmentResult other = (ClaimSegmentResult)o;
        if (this.getRequestId() != other.getRequestId()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        return Arrays.equals(this.getSegment(), other.getSegment());
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        long $requestId = this.getRequestId();
        result2 = result2 * 59 + (int)($requestId >>> 32 ^ $requestId);
        long $timestamp = this.getTimestamp();
        result2 = result2 * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        Position $position = this.getPosition();
        result2 = result2 * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        result2 = result2 * 59 + Arrays.hashCode(this.getSegment());
        return result2;
    }

    public String toString() {
        return "ClaimSegmentResult(requestId=" + this.getRequestId() + ", position=" + this.getPosition() + ", segment=" + Arrays.toString(this.getSegment()) + ", timestamp=" + this.getTimestamp() + ")";
    }

    public static final class Metric {
        private final long requestId;
        private final Long lastIndex;
        private final int[] segment;
        private final long timestamp;

        @ConstructorProperties(value={"requestId", "lastIndex", "segment", "timestamp"})
        public Metric(long requestId, Long lastIndex, int[] segment, long timestamp) {
            this.requestId = requestId;
            this.lastIndex = lastIndex;
            this.segment = segment;
            this.timestamp = timestamp;
        }

        public long getRequestId() {
            return this.requestId;
        }

        public Long getLastIndex() {
            return this.lastIndex;
        }

        public int[] getSegment() {
            return this.segment;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            Long this$lastIndex = this.getLastIndex();
            Long other$lastIndex = other.getLastIndex();
            if (this$lastIndex == null ? other$lastIndex != null : !((Object)this$lastIndex).equals(other$lastIndex)) {
                return false;
            }
            return Arrays.equals(this.getSegment(), other.getSegment());
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            long $requestId = this.getRequestId();
            result2 = result2 * 59 + (int)($requestId >>> 32 ^ $requestId);
            long $timestamp = this.getTimestamp();
            result2 = result2 * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            Long $lastIndex = this.getLastIndex();
            result2 = result2 * 59 + ($lastIndex == null ? 43 : ((Object)$lastIndex).hashCode());
            result2 = result2 * 59 + Arrays.hashCode(this.getSegment());
            return result2;
        }

        public String toString() {
            return "ClaimSegmentResult.Metric(requestId=" + this.getRequestId() + ", lastIndex=" + this.getLastIndex() + ", segment=" + Arrays.toString(this.getSegment()) + ", timestamp=" + this.getTimestamp() + ")";
        }
    }
}

