/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.tracking;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fluxcapacitor.common.api.SerializedMessage;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;

public final class MessageBatch {
    private final int[] segment;
    private final List<SerializedMessage> messages;
    private final Long lastIndex;

    @JsonIgnore
    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    @JsonIgnore
    public int getSize() {
        return this.messages.size();
    }

    public String toString() {
        return "MessageBatch{segment=" + Arrays.toString(this.segment) + ", lastIndex=" + this.lastIndex + ", message count=" + this.messages.size() + "}";
    }

    @JsonIgnore
    public Metric toMetric() {
        return new Metric(this.segment, this.getSize(), this.lastIndex);
    }

    @ConstructorProperties(value={"segment", "messages", "lastIndex"})
    public MessageBatch(int[] segment, List<SerializedMessage> messages, Long lastIndex) {
        this.segment = segment;
        this.messages = messages;
        this.lastIndex = lastIndex;
    }

    public int[] getSegment() {
        return this.segment;
    }

    public List<SerializedMessage> getMessages() {
        return this.messages;
    }

    public Long getLastIndex() {
        return this.lastIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageBatch)) {
            return false;
        }
        MessageBatch other = (MessageBatch)o;
        Long this$lastIndex = this.getLastIndex();
        Long other$lastIndex = other.getLastIndex();
        if (this$lastIndex == null ? other$lastIndex != null : !((Object)this$lastIndex).equals(other$lastIndex)) {
            return false;
        }
        if (!Arrays.equals(this.getSegment(), other.getSegment())) {
            return false;
        }
        List<SerializedMessage> this$messages = this.getMessages();
        List<SerializedMessage> other$messages = other.getMessages();
        return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Long $lastIndex = this.getLastIndex();
        result2 = result2 * 59 + ($lastIndex == null ? 43 : ((Object)$lastIndex).hashCode());
        result2 = result2 * 59 + Arrays.hashCode(this.getSegment());
        List<SerializedMessage> $messages = this.getMessages();
        result2 = result2 * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        return result2;
    }

    public static final class Metric {
        private final int[] segment;
        private final int size;
        private final Long lastIndex;

        @ConstructorProperties(value={"segment", "size", "lastIndex"})
        public Metric(int[] segment, int size, Long lastIndex) {
            this.segment = segment;
            this.size = size;
            this.lastIndex = lastIndex;
        }

        public int[] getSegment() {
            return this.segment;
        }

        public int getSize() {
            return this.size;
        }

        public Long getLastIndex() {
            return this.lastIndex;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            Long this$lastIndex = this.getLastIndex();
            Long other$lastIndex = other.getLastIndex();
            if (this$lastIndex == null ? other$lastIndex != null : !((Object)this$lastIndex).equals(other$lastIndex)) {
                return false;
            }
            return Arrays.equals(this.getSegment(), other.getSegment());
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            result2 = result2 * 59 + this.getSize();
            Long $lastIndex = this.getLastIndex();
            result2 = result2 * 59 + ($lastIndex == null ? 43 : ((Object)$lastIndex).hashCode());
            result2 = result2 * 59 + Arrays.hashCode(this.getSegment());
            return result2;
        }

        public String toString() {
            return "MessageBatch.Metric(segment=" + Arrays.toString(this.getSegment()) + ", size=" + this.getSize() + ", lastIndex=" + this.getLastIndex() + ")";
        }
    }
}

