/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.tracking;

import io.fluxcapacitor.common.api.SerializedMessage;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.IntStream;

public final class Position {
    public static int MAX_SEGMENT = 128;
    public static int[] FULL_SEGMENT = new int[]{0, MAX_SEGMENT};
    private final Map<Integer, Long> indexBySegment;

    public static Position newPosition() {
        return new Position(new HashMap<Integer, Long>());
    }

    public Position(long index) {
        this(new int[]{0, MAX_SEGMENT}, index);
    }

    public Position(int[] segment, long index) {
        HashMap<Integer, Long> indexBySegment = new HashMap<Integer, Long>();
        IntStream.range(segment[0], segment[1]).forEach(i -> indexBySegment.put(i, index));
        this.indexBySegment = indexBySegment;
    }

    public Optional<Long> getIndex(int segment) {
        return Optional.ofNullable(this.indexBySegment.get(segment));
    }

    public boolean isNew(int[] segment) {
        return this.indexBySegment.entrySet().stream().filter(entry -> entry.getValue() != null).noneMatch(entry -> (Integer)entry.getKey() >= segment[0] && (Integer)entry.getKey() < segment[1]);
    }

    public Optional<Long> lowestIndexForSegment(int[] segment) {
        int start = segment[0];
        int end = segment[1];
        return this.indexBySegment.entrySet().stream().filter(entry -> entry.getValue() != null).filter(entry -> (Integer)entry.getKey() >= start && (Integer)entry.getKey() < end).map(Map.Entry::getValue).sorted().findFirst();
    }

    public Position merge(Position newPosition) {
        HashMap<Integer, Long> indexBySegment = new HashMap<Integer, Long>(this.indexBySegment);
        newPosition.indexBySegment.forEach((s, i) -> indexBySegment.merge((Integer)s, (Long)i, (v, v2) -> v2.compareTo((Long)v) > 0 ? v2 : v));
        return new Position(indexBySegment);
    }

    public Map<int[], Long> splitInSegments() {
        HashMap<int[], Long> result2 = new HashMap<int[], Long>();
        new TreeMap<Integer, Long>(this.indexBySegment).entrySet().stream().map(e -> Map.entry(new int[]{(Integer)e.getKey(), (Integer)e.getKey() + 1}, (Long)e.getValue())).reduce((a, b) -> {
            if (Objects.equals(a.getValue(), b.getValue()) && ((int[])a.getKey())[1] == ((int[])b.getKey())[0]) {
                return Map.entry(new int[]{((int[])a.getKey())[0], ((int[])b.getKey())[1]}, (Long)b.getValue());
            }
            result2.put((int[])a.getKey(), (Long)a.getValue());
            return b;
        }).ifPresent(e -> result2.put((int[])e.getKey(), (Long)e.getValue()));
        return result2;
    }

    public boolean isNewMessage(SerializedMessage message) {
        Long index = this.indexBySegment.get(message.getSegment());
        return index == null || index < message.getIndex();
    }

    public Map<Integer, Long> getIndexBySegment() {
        return this.indexBySegment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Position)) {
            return false;
        }
        Position other = (Position)o;
        Map<Integer, Long> this$indexBySegment = this.getIndexBySegment();
        Map<Integer, Long> other$indexBySegment = other.getIndexBySegment();
        return !(this$indexBySegment == null ? other$indexBySegment != null : !((Object)this$indexBySegment).equals(other$indexBySegment));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Map<Integer, Long> $indexBySegment = this.getIndexBySegment();
        result2 = result2 * 59 + ($indexBySegment == null ? 43 : ((Object)$indexBySegment).hashCode());
        return result2;
    }

    public String toString() {
        return "Position(indexBySegment=" + this.getIndexBySegment() + ")";
    }

    @ConstructorProperties(value={"indexBySegment"})
    public Position(Map<Integer, Long> indexBySegment) {
        this.indexBySegment = indexBySegment;
    }
}

