/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.tracking;

import io.fluxcapacitor.common.api.QueryResult;
import io.fluxcapacitor.common.api.SerializedMessage;
import java.beans.ConstructorProperties;
import java.util.List;

public final class ReadFromIndexResult
implements QueryResult {
    private final long requestId;
    private final List<SerializedMessage> messages;
    private final long timestamp = System.currentTimeMillis();

    @Override
    public Metric toMetric() {
        return new Metric(this.messages.size(), this.timestamp);
    }

    @ConstructorProperties(value={"requestId", "messages"})
    public ReadFromIndexResult(long requestId, List<SerializedMessage> messages) {
        this.requestId = requestId;
        this.messages = messages;
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    public List<SerializedMessage> getMessages() {
        return this.messages;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadFromIndexResult)) {
            return false;
        }
        ReadFromIndexResult other = (ReadFromIndexResult)o;
        if (this.getRequestId() != other.getRequestId()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        List<SerializedMessage> this$messages = this.getMessages();
        List<SerializedMessage> other$messages = other.getMessages();
        return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        long $requestId = this.getRequestId();
        result2 = result2 * 59 + (int)($requestId >>> 32 ^ $requestId);
        long $timestamp = this.getTimestamp();
        result2 = result2 * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        List<SerializedMessage> $messages = this.getMessages();
        result2 = result2 * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        return result2;
    }

    public String toString() {
        return "ReadFromIndexResult(requestId=" + this.getRequestId() + ", messages=" + this.getMessages() + ", timestamp=" + this.getTimestamp() + ")";
    }

    public static final class Metric {
        private final int size;
        private final long timestamp;

        @ConstructorProperties(value={"size", "timestamp"})
        public Metric(int size, long timestamp) {
            this.size = size;
            this.timestamp = timestamp;
        }

        public int getSize() {
            return this.size;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            return this.getTimestamp() == other.getTimestamp();
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            result2 = result2 * 59 + this.getSize();
            long $timestamp = this.getTimestamp();
            result2 = result2 * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            return result2;
        }

        public String toString() {
            return "ReadFromIndexResult.Metric(size=" + this.getSize() + ", timestamp=" + this.getTimestamp() + ")";
        }
    }
}

