/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.handling;

import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.HandlerMatcher;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.reflection.DefaultMemberInvoker;
import io.fluxcapacitor.common.reflection.MemberInvoker;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerInspector {
    public static boolean hasHandlerMethods(Class<?> targetClass, HandlerConfiguration<?> handlerConfiguration) {
        return Stream.concat(ReflectionUtils.getAllMethods(targetClass).stream(), Arrays.stream(targetClass.getConstructors())).anyMatch(m -> handlerConfiguration.methodMatches(targetClass, (Executable)m));
    }

    public static <M> Handler<M> createHandler(Object target, Class<? extends Annotation> methodAnnotation) {
        return HandlerInspector.createHandler(target, methodAnnotation, List.of((p, a) -> o -> o));
    }

    public static <M> Handler<M> createHandler(Object target, Class<? extends Annotation> methodAnnotation, List<ParameterResolver<? super M>> parameterResolvers) {
        return HandlerInspector.createHandler(target, parameterResolvers, HandlerConfiguration.builder().methodAnnotation(methodAnnotation).build());
    }

    public static <M> Handler<M> createHandler(Object target, List<ParameterResolver<? super M>> parameterResolvers, HandlerConfiguration<? super M> config) {
        return new DefaultHandler<M>(target, HandlerInspector.inspect(target.getClass(), parameterResolvers, config));
    }

    public static <M> HandlerMatcher<Object, M> inspect(Class<?> c, List<ParameterResolver<? super M>> parameterResolvers, Class<? extends Annotation> methodAnnotation) {
        return HandlerInspector.inspect(c, parameterResolvers, HandlerConfiguration.builder().methodAnnotation(methodAnnotation).build());
    }

    public static <M> HandlerMatcher<Object, M> inspect(Class<?> c, List<ParameterResolver<? super M>> parameterResolvers, HandlerConfiguration<? super M> config) {
        return new ObjectHandlerMatcher(Stream.concat(ReflectionUtils.getAllMethods(c).stream(), Arrays.stream(c.getDeclaredConstructors())).filter(m -> config.methodMatches(c, (Executable)m)).flatMap(m -> Stream.of(new MethodHandlerMatcher((Executable)m, c, parameterResolvers, config))).sorted(MethodHandlerMatcher.comparator).collect(Collectors.toList()), config.invokeMultipleMethods());
    }

    public static class DefaultHandler<M>
    implements Handler<M> {
        private static final Logger log = LoggerFactory.getLogger(DefaultHandler.class);
        private final Object target;
        private final HandlerMatcher<Object, M> invoker;

        @Override
        public Object getTarget() {
            return this.target;
        }

        @Override
        public Optional<HandlerInvoker> findInvoker(M message) {
            return this.invoker.findInvoker(this.target, message);
        }

        public String toString() {
            return Optional.ofNullable(this.target).map(o -> String.format("\"%s\"", o.getClass().getSimpleName())).orElse("DefaultHandler");
        }

        @ConstructorProperties(value={"target", "invoker"})
        public DefaultHandler(Object target, HandlerMatcher<Object, M> invoker) {
            this.target = target;
            this.invoker = invoker;
        }
    }

    public static class ObjectHandlerMatcher<M>
    implements HandlerMatcher<Object, M> {
        private final List<HandlerMatcher<Object, M>> methodHandlers;
        private final boolean invokeMultipleMethods;

        @Override
        public Optional<HandlerInvoker> findInvoker(Object target, M message) {
            if (this.invokeMultipleMethods) {
                HandlerInvoker invoker = null;
                for (HandlerMatcher<Object, M> d : this.methodHandlers) {
                    Optional<HandlerInvoker> s = d.findInvoker(target, message);
                    if (!s.isPresent()) continue;
                    invoker = invoker == null ? s.get() : invoker.combine(s.get());
                }
                return Optional.ofNullable(invoker);
            }
            for (HandlerMatcher<Object, M> d : this.methodHandlers) {
                Optional<HandlerInvoker> s = d.findInvoker(target, message);
                if (!s.isPresent()) continue;
                return s;
            }
            return Optional.empty();
        }

        @ConstructorProperties(value={"methodHandlers", "invokeMultipleMethods"})
        public ObjectHandlerMatcher(List<HandlerMatcher<Object, M>> methodHandlers, boolean invokeMultipleMethods) {
            this.methodHandlers = methodHandlers;
            this.invokeMultipleMethods = invokeMultipleMethods;
        }
    }

    public static class MethodHandlerMatcher<M>
    implements HandlerMatcher<Object, M> {
        protected static final Comparator<MethodHandlerMatcher<?>> comparator = Comparator.comparing(MethodHandlerMatcher::getPriority, Comparator.reverseOrder()).thenComparing(MethodHandlerMatcher::getClassForSpecificity, (o1, o2) -> Objects.equals(o1, o2) ? 0 : (o1 == null ? 1 : (o2 == null ? -1 : (o1.isAssignableFrom((Class<?>)o2) ? 1 : (o2.isAssignableFrom((Class<?>)o1) ? -1 : (o1.isInterface() && !o2.isInterface() ? 1 : (!o1.isInterface() && o2.isInterface() ? -1 : MethodHandlerMatcher.specificity(o2) - MethodHandlerMatcher.specificity(o1)))))))).thenComparingInt(a -> -a.getParameterCount()).thenComparingInt(MethodHandlerMatcher::getMethodIndex);
        private final int methodIndex;
        private final Executable executable;
        private final Parameter[] parameters;
        private final int parameterCount;
        private final boolean staticMethod;
        private final MemberInvoker invoker;
        private final boolean hasReturnValue;
        private final Class<?> classForSpecificity;
        private final Annotation methodAnnotation;
        private final int priority;
        private final boolean passive;
        private final List<ParameterResolver<? super M>> parameterResolvers;
        private final HandlerConfiguration<? super M> config;
        private final Optional<Object> emptyResult = Optional.of(Void.TYPE);

        public MethodHandlerMatcher(Executable executable, Class<?> enclosingType, List<ParameterResolver<? super M>> parameterResolvers, @NonNull HandlerConfiguration<? super M> config) {
            if (config == null) {
                throw new NullPointerException("config is marked non-null but is null");
            }
            this.parameterResolvers = parameterResolvers;
            this.config = config;
            this.methodIndex = executable instanceof Method ? this.methodIndex((Method)executable, enclosingType) : 0;
            this.executable = ReflectionUtils.ensureAccessible(executable);
            this.parameters = this.executable.getParameters();
            this.parameterCount = this.parameters.length;
            this.staticMethod = Modifier.isStatic(this.executable.getModifiers());
            this.hasReturnValue = !(executable instanceof Method) || !((Method)executable).getReturnType().equals(Void.TYPE);
            this.methodAnnotation = config.getAnnotation(executable).orElse(null);
            this.classForSpecificity = this.computeClassForSpecificity();
            this.priority = this.getPriority(this.methodAnnotation);
            this.passive = this.isPassive(this.methodAnnotation);
            this.invoker = DefaultMemberInvoker.asInvoker(this.executable);
        }

        @Override
        public Optional<HandlerInvoker> findInvoker(final Object target, final M m) {
            if (!this.config.messageFilter().test(m, this.executable) || (target == null ? !(this.executable instanceof Constructor) && !this.staticMethod : !(this.executable instanceof Method) || this.staticMethod)) {
                return Optional.empty();
            }
            if (this.parameterCount == 0) {
                return Optional.of(new MethodHandlerInvoker(target){

                    @Override
                    public Object invoke(BiFunction<Object, Object, Object> combiner) {
                        return invoker.invoke(target);
                    }
                });
            }
            final Function[] matchingResolvers = new Function[this.parameterCount];
            for (int i = 0; i < this.parameterCount; ++i) {
                Parameter p = this.parameters[i];
                ParameterResolver<M> matchingResolver = null;
                for (ParameterResolver<M> r : this.parameterResolvers) {
                    if (!r.matches(p, this.methodAnnotation, m, target)) continue;
                    matchingResolver = r;
                    break;
                }
                if (matchingResolver == null || !matchingResolver.filterMessage(m, p)) {
                    return Optional.empty();
                }
                matchingResolvers[i] = matchingResolver.resolve(p, this.methodAnnotation);
            }
            return Optional.of(new MethodHandlerInvoker(target){

                @Override
                public Object invoke(BiFunction<Object, Object, Object> combiner) {
                    return invoker.invoke(target, parameterCount, i -> matchingResolvers[i].apply(m));
                }
            });
        }

        protected Class<?> computeClassForSpecificity() {
            for (Parameter p : this.parameters) {
                for (ParameterResolver<M> r : this.parameterResolvers) {
                    Function<? super M, Object> resolver;
                    if (!r.determinesSpecificity() || (resolver = r.resolve(p, this.methodAnnotation)) == null) continue;
                    return p.getType();
                }
            }
            return null;
        }

        protected static int specificity(Class<?> type2) {
            Class<?> t;
            int depth = 0;
            if (type2.isInterface()) {
                while (t.getInterfaces().length > 0) {
                    ++depth;
                    t = t.getInterfaces()[0];
                }
            } else {
                for (t = type2; t != null; t = t.getSuperclass()) {
                    ++depth;
                }
            }
            return depth;
        }

        protected int methodIndex(Method instanceMethod, Class<?> instanceType) {
            return ReflectionUtils.getAllMethods(instanceType).indexOf(instanceMethod);
        }

        protected int getPriority(Annotation annotation) {
            if (annotation == null) {
                return 0;
            }
            Optional<Method> match = Arrays.stream(annotation.annotationType().getMethods()).filter(m -> m.getName().equals("priority")).findFirst();
            if (match.isPresent()) {
                return (Integer)match.get().invoke((Object)annotation, new Object[0]);
            }
            return 0;
        }

        protected boolean isPassive(Annotation annotation) {
            if (annotation == null) {
                return false;
            }
            Optional<Method> match = Arrays.stream(annotation.annotationType().getMethods()).filter(m -> m.getName().equals("passive")).findFirst();
            if (match.isPresent()) {
                return (Boolean)match.get().invoke((Object)annotation, new Object[0]);
            }
            return false;
        }

        public int getMethodIndex() {
            return this.methodIndex;
        }

        public Executable getExecutable() {
            return this.executable;
        }

        public Parameter[] getParameters() {
            return this.parameters;
        }

        public int getParameterCount() {
            return this.parameterCount;
        }

        public boolean isStaticMethod() {
            return this.staticMethod;
        }

        public MemberInvoker getInvoker() {
            return this.invoker;
        }

        public boolean isHasReturnValue() {
            return this.hasReturnValue;
        }

        public Class<?> getClassForSpecificity() {
            return this.classForSpecificity;
        }

        public Annotation getMethodAnnotation() {
            return this.methodAnnotation;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean isPassive() {
            return this.passive;
        }

        public List<ParameterResolver<? super M>> getParameterResolvers() {
            return this.parameterResolvers;
        }

        public HandlerConfiguration<? super M> getConfig() {
            return this.config;
        }

        public Optional<Object> getEmptyResult() {
            return this.emptyResult;
        }

        protected abstract class MethodHandlerInvoker
        implements HandlerInvoker {
            private final Object target;

            @Override
            public Object getTarget() {
                return this.target;
            }

            @Override
            public Executable getMethod() {
                return MethodHandlerMatcher.this.executable;
            }

            @Override
            public boolean expectResult() {
                return MethodHandlerMatcher.this.hasReturnValue;
            }

            @Override
            public boolean isPassive() {
                return MethodHandlerMatcher.this.passive;
            }

            @ConstructorProperties(value={"target"})
            public MethodHandlerInvoker(Object target) {
                this.target = target;
            }
        }
    }
}

