/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.handling;

import io.fluxcapacitor.common.Registration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

public final class Invocation {
    private static final ThreadLocal<Invocation> current = new ThreadLocal();
    private final AtomicReference<Object> id = new AtomicReference();
    private final transient List<BiConsumer<Object, Throwable>> callbacks = new ArrayList<BiConsumer<Object, Throwable>>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <V> V performInvocation(Callable<V> callable) {
        if (current.get() != null) {
            return callable.call();
        }
        Invocation invocation = new Invocation();
        current.set(invocation);
        try {
            V result2 = callable.call();
            invocation.getCallbacks().forEach(c -> c.accept(result2, null));
            V v = result2;
            return v;
        }
        catch (Throwable e) {
            invocation.getCallbacks().forEach(c -> c.accept(null, e));
            throw e;
        }
        finally {
            current.set(null);
        }
    }

    public static Invocation getCurrent() {
        return current.get();
    }

    public static Registration whenHandlerCompletes(BiConsumer<Object, Throwable> callback) {
        Invocation invocation = current.get();
        if (invocation == null) {
            callback.accept(null, null);
            return Registration.noOp();
        }
        return invocation.registerCallback(callback);
    }

    private Registration registerCallback(BiConsumer<Object, Throwable> callback) {
        this.callbacks.add(callback);
        return () -> this.callbacks.remove(callback);
    }

    public List<BiConsumer<Object, Throwable>> getCallbacks() {
        return this.callbacks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Invocation)) {
            return false;
        }
        Invocation other = (Invocation)o;
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $id = this.getId();
        result2 = result2 * 59 + ($id == null ? 43 : $id.hashCode());
        return result2;
    }

    public String toString() {
        return "Invocation(id=" + this.getId() + ", callbacks=" + this.getCallbacks() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId() {
        Object value = this.id.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.id;
            synchronized (atomicReference) {
                value = this.id.get();
                if (value == null) {
                    String actualValue = UUID.randomUUID().toString();
                    value = actualValue == null ? this.id : actualValue;
                    this.id.set(value);
                }
            }
        }
        return (String)(value == this.id ? null : value);
    }
}

