/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.handling;

import java.lang.reflect.Executable;
import lombok.NonNull;

@FunctionalInterface
public interface MessageFilter<M> {
    public boolean test(M var1, Executable var2);

    default public MessageFilter<M> and(@NonNull MessageFilter<? super M> other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return (m, e) -> this.test(m, e) && other.test(m, e);
    }

    default public MessageFilter<M> negate() {
        return (m, e) -> !this.test(m, e);
    }

    default public MessageFilter<M> or(@NonNull MessageFilter<? super M> other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return (m, e) -> this.test(m, e) || other.test(m, e);
    }
}

