/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.handling;

import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.function.Function;

@FunctionalInterface
public interface ParameterResolver<M> {
    public Function<M, Object> resolve(Parameter var1, Annotation var2);

    default public boolean matches(Parameter parameter, Annotation methodAnnotation, M value, Object target) {
        Function<M, Object> function = this.resolve(parameter, methodAnnotation);
        if (function == null) {
            return false;
        }
        Object parameterValue = function.apply(value);
        return parameterValue == null || parameter.getType().isAssignableFrom(parameterValue.getClass());
    }

    default public boolean determinesSpecificity() {
        return false;
    }

    default public boolean filterMessage(M message, Parameter parameter) {
        return true;
    }
}

