/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.reflection;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.reflection.DefaultMemberInvoker;
import io.fluxcapacitor.common.reflection.KotlinReflectionUtils;
import io.fluxcapacitor.common.serialization.JsonUtils;
import java.beans.ConstructorProperties;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.reflect.KParameter;
import lombok.NonNull;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class ReflectionUtils {
    private static final int ACCESS_MODIFIERS = 7;
    private static final List<Integer> ACCESS_ORDER = List.of(Integer.valueOf(2), Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(1));
    private static final Function<Class<?>, List<Method>> methodsCache = ObjectUtils.memoize(ReflectionUtils::computeAllMethods);
    private static final Function<String, Class<?>> classForNameCache = ObjectUtils.memoize(ReflectionUtils::computeClass);
    private static final BiFunction<Class<?>, Class<? extends Annotation>, List<? extends AccessibleObject>> annotatedPropertiesCache = ObjectUtils.memoize(ReflectionUtils::computeAnnotatedProperties);
    private static final BiFunction<Class<?>, String, Function<Object, Object>> gettersCache = ObjectUtils.memoize(ReflectionUtils::computeNestedGetter);
    private static final BiFunction<String, Class<?>, BiConsumer<Object, Object>> settersCache = ObjectUtils.memoize(ReflectionUtils::computeNestedSetter);
    private static final Function<Parameter, Boolean> isNullableCache = ObjectUtils.memoize(parameter -> {
        KParameter kotlinParameter;
        if (ReflectionUtils.isKotlinReflectionSupported() && (kotlinParameter = KotlinReflectionUtils.asKotlinParameter(parameter)) != null && kotlinParameter.getType().isMarkedNullable()) {
            return true;
        }
        return Arrays.stream(parameter.getAnnotations()).anyMatch(a -> a.annotationType().getSimpleName().equals("Nullable"));
    });

    public static boolean isKotlinReflectionSupported() {
        return ReflectionUtils.classExists("kotlin.reflect.full.KClasses");
    }

    public static List<Method> getAllMethods(Class<?> type2) {
        return methodsCache.apply(type2);
    }

    private static List<Method> computeAllMethods(Class<?> type2) {
        Predicate<Method> include = m -> !m.isBridge() && !m.isSynthetic() && Character.isJavaIdentifierStart(m.getName().charAt(0)) && m.getName().chars().skip(1L).allMatch(Character::isJavaIdentifierPart);
        LinkedHashSet<Method> methods2 = new LinkedHashSet<Method>();
        Collections.addAll(methods2, type2.getMethods());
        methods2.removeIf(include.negate());
        Stream.of(type2.getDeclaredMethods()).filter(include).forEach(methods2::add);
        int access = 7;
        Package p = type2.getPackage();
        HashMap<Object, Set> types = new HashMap<Object, Set>();
        Set pkgIndependent = Collections.emptySet();
        for (Method m2 : methods2) {
            int acc = m2.getModifiers() & 7;
            if (acc == 2) continue;
            if (acc != 0) {
                types.put(ReflectionUtils.methodKey(m2), pkgIndependent);
                continue;
            }
            types.computeIfAbsent(ReflectionUtils.methodKey(m2), x -> new HashSet()).add(p);
        }
        include = include.and(m -> {
            int acc = m.getModifiers() & 7;
            return acc != 0 ? acc == 2 || types.putIfAbsent(ReflectionUtils.methodKey(m), pkgIndependent) == null : ReflectionUtils.noPkgOverride(m, types, pkgIndependent);
        });
        for (type2 = type2.getSuperclass(); type2 != null; type2 = type2.getSuperclass()) {
            Stream.of(type2.getDeclaredMethods()).filter(include).forEach(methods2::add);
        }
        return new ArrayList<Method>(methods2);
    }

    private static boolean noPkgOverride(Method m, Map<Object, Set<Package>> types, Set<Package> pkgIndependent) {
        Set pkg = types.computeIfAbsent(ReflectionUtils.methodKey(m), key -> new HashSet());
        return pkg != pkgIndependent && pkg.add(m.getDeclaringClass().getPackage());
    }

    private static Object methodKey(Method m) {
        return Arrays.asList(m.getName(), MethodType.methodType(m.getReturnType(), m.getParameterTypes()));
    }

    public static List<?> getAnnotatedPropertyValues(Object target, Class<? extends Annotation> annotation) {
        if (target == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (AccessibleObject accessibleObject : ReflectionUtils.getAnnotatedProperties(target.getClass(), annotation)) {
            result2.add(ReflectionUtils.getValue(accessibleObject, target));
        }
        return result2;
    }

    public static List<? extends AccessibleObject> getAnnotatedProperties(Class<?> target, Class<? extends Annotation> annotation) {
        return annotatedPropertiesCache.apply(target, annotation);
    }

    private static List<? extends AccessibleObject> computeAnnotatedProperties(Class<?> target, Class<? extends Annotation> annotation) {
        ArrayList<Field> result2 = new ArrayList<Field>(FieldUtils.getFieldsListWithAnnotation(target, annotation));
        result2.addAll(MethodUtils.getMethodsListWithAnnotation(target, annotation, true, true).stream().filter(m -> m.getParameterCount() == 0).collect(Collectors.toList()));
        ClassUtils.getAllInterfaces(target).forEach(i -> result2.addAll(FieldUtils.getFieldsListWithAnnotation(i, annotation)));
        result2.forEach(ReflectionUtils::ensureAccessible);
        return result2;
    }

    public static Optional<? extends AccessibleObject> getAnnotatedProperty(Object target, Class<? extends Annotation> annotation) {
        return target == null ? Optional.empty() : ReflectionUtils.getAnnotatedProperty(target.getClass(), annotation);
    }

    public static Optional<? extends AccessibleObject> getAnnotatedProperty(Class<?> target, Class<? extends Annotation> annotation) {
        List<? extends AccessibleObject> annotatedProperties = ReflectionUtils.getAnnotatedProperties(target, annotation);
        return annotatedProperties.isEmpty() ? Optional.empty() : Optional.of(annotatedProperties.get(0));
    }

    public static Optional<?> getAnnotatedPropertyValue(Object target, Class<? extends Annotation> annotation) {
        return ReflectionUtils.getAnnotatedProperty(target, annotation).map(m -> ReflectionUtils.getValue(m, target, false));
    }

    public static List<Method> getAnnotatedMethods(Object target, Class<? extends Annotation> annotation) {
        return MethodUtils.getMethodsListWithAnnotation(target.getClass(), annotation, true, true);
    }

    public static List<Field> getAnnotatedFields(Object target, Class<? extends Annotation> annotation) {
        if (target == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Field>(FieldUtils.getFieldsListWithAnnotation(target.getClass(), annotation));
    }

    public static boolean isAnnotationPresent(Class<?> type2, Class<? extends Annotation> annotationType) {
        return ReflectionUtils.getTypeAnnotation(type2, annotationType) != null;
    }

    public static <A extends Annotation> A getTypeAnnotation(Class<?> type2, Class<A> annotationType) {
        A result2 = type2.getAnnotation(annotationType);
        if (result2 == null) {
            Class<?> iFace;
            Class<?>[] classArray = type2.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (result2 = (iFace = classArray[i]).getAnnotation(annotationType)) == null; ++i) {
            }
        }
        return result2;
    }

    public static <A extends Annotation> Optional<A> getPackageAnnotation(Package p, Class<A> annotationType) {
        return Optional.ofNullable(p.getAnnotation(annotationType));
    }

    public static <T> Optional<T> readProperty(String propertyPath, Object target) {
        if (target == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(gettersCache.apply(target.getClass(), propertyPath).apply(target)).map(v -> v);
        }
        catch (PropertyNotFoundException ignored) {
            return Optional.empty();
        }
    }

    public static boolean hasProperty(String propertyPath, Object target) {
        if (target == null) {
            return false;
        }
        try {
            gettersCache.apply(target.getClass(), propertyPath).apply(target);
            return true;
        }
        catch (PropertyNotFoundException ignored) {
            return false;
        }
    }

    private static Function<Object, Object> computeNestedGetter(Class<?> type2, String propertyPath) {
        String[] parts = (String[])Arrays.stream(propertyPath.replace('.', '/').split("/")).filter(s -> !s.isBlank()).toArray(String[]::new);
        if (parts.length == 1) {
            return ReflectionUtils.computeGetter(type2, parts[0]);
        }
        return object -> {
            for (String part : parts) {
                if (object == null) {
                    return null;
                }
                object = gettersCache.apply(object.getClass(), part).apply(object);
            }
            return object;
        };
    }

    private static Function<Object, Object> computeGetter(@NonNull Class<?> type2, @NonNull String propertyName) {
        if (type2 == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        if (ObjectNode.class.isAssignableFrom(type2)) {
            return target -> ((ObjectNode)target).get(propertyName);
        }
        PropertyNotFoundException notFoundException = new PropertyNotFoundException(propertyName, type2);
        return Optional.ofNullable(MethodUtils.getMatchingMethod(type2, "get" + StringUtils.capitalize(propertyName), new Class[0])).or(() -> Optional.ofNullable(MethodUtils.getMatchingMethod(type2, propertyName, new Class[0]))).or(() -> Optional.ofNullable(FieldUtils.getField(type2, propertyName, true))).map(DefaultMemberInvoker::asInvoker).map(invoker -> invoker::invoke).orElseGet(() -> o -> {
            throw notFoundException;
        });
    }

    public static Object getValue(AccessibleObject fieldOrMethod, Object target, boolean forceAccess) {
        if (fieldOrMethod instanceof Method) {
            return DefaultMemberInvoker.asInvoker((Method)fieldOrMethod, forceAccess).invoke(target);
        }
        if (fieldOrMethod instanceof Field) {
            return DefaultMemberInvoker.asInvoker((Field)fieldOrMethod, forceAccess).invoke(target);
        }
        throw new IllegalStateException("Object property should be field or method: " + fieldOrMethod);
    }

    public static Object getValue(AccessibleObject fieldOrMethod, Object target) {
        return ReflectionUtils.getValue(fieldOrMethod, target, true);
    }

    public static String getName(AccessibleObject fieldOrMethod) {
        if (fieldOrMethod instanceof Member) {
            return ((Member)((Object)fieldOrMethod)).getName();
        }
        throw new IllegalStateException("Object property should be field or method: " + fieldOrMethod);
    }

    public static Class<?> getEnclosingClass(AccessibleObject fieldOrMethod) {
        if (fieldOrMethod instanceof Member) {
            return ((Member)((Object)fieldOrMethod)).getDeclaringClass();
        }
        throw new IllegalStateException("Object property should be field or method: " + fieldOrMethod);
    }

    public static Class<?> getPropertyType(AccessibleObject fieldOrMethod) {
        if (fieldOrMethod instanceof Method) {
            return ((Method)fieldOrMethod).getReturnType();
        }
        if (fieldOrMethod instanceof Field) {
            return ((Field)fieldOrMethod).getType();
        }
        throw new IllegalStateException("Object property should be field or method: " + fieldOrMethod);
    }

    public static Type getGenericPropertyType(AccessibleObject fieldOrMethod) {
        if (fieldOrMethod instanceof Method) {
            return ((Method)fieldOrMethod).getGenericReturnType();
        }
        if (fieldOrMethod instanceof Field) {
            return ((Field)fieldOrMethod).getGenericType();
        }
        throw new IllegalStateException("Object property should be field or method: " + fieldOrMethod);
    }

    public static void writeProperty(String propertyPath, Object target, Object value) {
        if (target != null) {
            try {
                settersCache.apply(propertyPath, target.getClass()).accept(target, value);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
        }
    }

    private static BiConsumer<Object, Object> computeNestedSetter(@NonNull String propertyPath, @NonNull Class<?> type2) {
        if (propertyPath == null) {
            throw new NullPointerException("propertyPath is marked non-null but is null");
        }
        if (type2 == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        String[] parts = (String[])Arrays.stream(propertyPath.replace('.', '/').split("/")).filter(s -> !s.isBlank()).toArray(String[]::new);
        if (parts.length == 1) {
            return ReflectionUtils.computeSetter(parts[0], type2);
        }
        Function<Object, Object> parentSupplier = gettersCache.apply(type2, Arrays.stream(parts).limit(parts.length - 1).collect(Collectors.joining("/")));
        return (object, value) -> {
            Object parent = parentSupplier.apply(object);
            if (parent != null) {
                BiConsumer<Object, Object> setter = settersCache.apply(parts[parts.length - 1], parent.getClass());
                setter.accept(parent, value);
            }
        };
    }

    private static BiConsumer<Object, Object> computeSetter(@NonNull String propertyName, @NonNull Class<?> type2) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        if (type2 == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (ObjectNode.class.isAssignableFrom(type2)) {
            return (target, propertyValue) -> ((ObjectNode)target).putPOJO(propertyName, propertyValue);
        }
        PropertyNotFoundException notFoundException = new PropertyNotFoundException(propertyName, type2);
        return Arrays.stream(Introspector.getBeanInfo(type2, Object.class).getPropertyDescriptors()).filter(d -> propertyName.equals(d.getName())).map(PropertyDescriptor::getWriteMethod).filter(Objects::nonNull).findFirst().or(() -> Optional.ofNullable(FieldUtils.getField(type2, propertyName, true))).map(DefaultMemberInvoker::asInvoker).map(invoker -> invoker::invoke).orElseGet(() -> (t, v) -> {
            throw notFoundException;
        });
    }

    private static void setValue(Member fieldOrMethod, Object target, Object value) {
        DefaultMemberInvoker.asInvoker(fieldOrMethod).invoke(target, value);
    }

    public static boolean isOrHas(Annotation annotation, Class<? extends Annotation> annotationType) {
        return annotation != null && (Objects.equals(annotation.annotationType(), annotationType) || annotation.annotationType().isAnnotationPresent(annotationType));
    }

    public static Class<?> getPropertyType(Class<?> target, String propertyName) {
        Field field = FieldUtils.getField(target, propertyName);
        return field != null ? field.getType() : Arrays.stream(Introspector.getBeanInfo(target, Object.class).getPropertyDescriptors()).filter(d -> propertyName.equals(d.getName())).map(PropertyDescriptor::getPropertyType).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Property %s could not be found on target class %s", propertyName, target)));
    }

    public static Optional<Field> getField(Class<?> owner, String name) {
        while (owner != null) {
            for (Field declaredField2 : owner.getDeclaredFields()) {
                if (!declaredField2.getName().equals(name)) continue;
                return Optional.of(declaredField2);
            }
            owner = owner.getSuperclass();
        }
        return Optional.empty();
    }

    public static Class<?> getCallerClass() {
        return StackWalker.getInstance(Set.of(StackWalker.Option.RETAIN_CLASS_REFERENCE)).walk(s -> {
            Iterator iterator2 = s.skip(1L).iterator();
            Class<?> invoker = ((StackWalker.StackFrame)iterator2.next()).getDeclaringClass();
            while (iterator2.hasNext()) {
                StackWalker.StackFrame frame = (StackWalker.StackFrame)iterator2.next();
                Class<?> frameClass = frame.getDeclaringClass();
                if (frameClass.equals(invoker) || frameClass.getName().startsWith("java.")) continue;
                return frameClass;
            }
            return null;
        });
    }

    public static boolean isNullable(Parameter parameter) {
        return isNullableCache.apply(parameter);
    }

    public static <T> T asInstance(Object classOrInstance) {
        if (classOrInstance instanceof Class) {
            try {
                return ReflectionUtils.ensureAccessible(((Class)classOrInstance).getDeclaredConstructor(new Class[0])).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Failed to create an instance of class %s. Does it have an accessible default constructor?", classOrInstance), e);
            }
        }
        return (T)classOrInstance;
    }

    public static int getParameterIndex(Parameter parameter) {
        Executable executable = parameter.getDeclaringExecutable();
        for (int i = 0; i < executable.getParameters().length; ++i) {
            if (!executable.getParameters()[i].equals(parameter)) continue;
            return i;
        }
        throw new IllegalStateException("Could not get parameter index of " + parameter);
    }

    public static List<Package> getPackageAndParentPackages(Package p) {
        ArrayList<Package> result2 = new ArrayList<Package>();
        while (p != null) {
            result2.add(p);
            p = ReflectionUtils.getParentPackage(p);
        }
        return result2;
    }

    private static Package getParentPackage(Package p) {
        String name = p.getName();
        int lastIndex = name.lastIndexOf(".");
        if (lastIndex < 0) {
            return null;
        }
        String parentName = name.substring(0, lastIndex);
        for (Package candidate : Package.getPackages()) {
            if (!candidate.getName().equals(parentName)) continue;
            return candidate;
        }
        return null;
    }

    public static Optional<Class<?>> getCollectionElementType(AccessibleObject fieldOrMethod) {
        if (fieldOrMethod instanceof Method) {
            return ReflectionUtils.getCollectionElementType(((Method)fieldOrMethod).getGenericReturnType());
        }
        if (fieldOrMethod instanceof Field) {
            return ReflectionUtils.getCollectionElementType(((Field)fieldOrMethod).getGenericType());
        }
        throw new IllegalStateException("Object property should be field or method: " + fieldOrMethod);
    }

    public static Optional<Class<?>> getCollectionElementType(Type parameterizedType) {
        if (parameterizedType instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)parameterizedType).getRawType();
            Type elementType = rawType instanceof Class && Map.class.isAssignableFrom((Class)rawType) ? ((ParameterizedType)parameterizedType).getActualTypeArguments()[1] : ((ParameterizedType)parameterizedType).getActualTypeArguments()[0];
            if (elementType instanceof WildcardType) {
                Type[] upperBounds2 = ((WildcardType)elementType).getUpperBounds();
                elementType = upperBounds2.length > 0 ? upperBounds2[0] : null;
            }
            return Optional.of(elementType instanceof Class ? (Class)elementType : Object.class);
        }
        return Optional.empty();
    }

    public static boolean declaresField(Class<?> target, String fieldName) {
        return !StringUtils.isEmpty(fieldName) && FieldUtils.getDeclaredField(target, fieldName, true) != null;
    }

    public static void setField(Field field, Object target, Object value) {
        ReflectionUtils.ensureAccessible(field).set(target, value);
    }

    public static void setField(String fieldName, Object target, Object value) {
        ReflectionUtils.setField(target.getClass().getDeclaredField(fieldName), target, value);
    }

    public static <T extends AccessibleObject> T ensureAccessible(T member) {
        AccessController.doPrivileged(() -> {
            member.setAccessible(true);
            return null;
        });
        return member;
    }

    public static Collection<? extends Annotation> getTypeAnnotations(Class<?> type2) {
        return Stream.concat(Arrays.stream(type2.getAnnotations()), Arrays.stream(type2.getAnnotatedInterfaces()).map(AnnotatedType::getType).flatMap(t -> {
            if (t instanceof ParameterizedType) {
                t = ((ParameterizedType)t).getRawType();
            }
            if (t instanceof Class) {
                return Stream.of((Class)t);
            }
            return Stream.empty();
        }).map(t -> t).flatMap(i -> Arrays.stream(i.getAnnotations()))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Class<?> classForName(String type2) {
        return classForNameCache.apply(type2);
    }

    public static <A extends Annotation> Optional<A> getAnnotation(Executable m, Class<A> a) {
        return ReflectionUtils.getAnnotationAs(m, a, a);
    }

    public static <T> Optional<T> getAnnotationAs(Executable m, Class<? extends Annotation> a, Class<T> returnType) {
        if (a == null) {
            return Optional.empty();
        }
        Annotation result2 = ReflectionUtils.getMethodAnnotation(m, a).orElse(null);
        if (result2 == null) {
            return Optional.empty();
        }
        if (a.equals(returnType)) {
            if (result2.annotationType().equals(returnType)) {
                return Optional.of(result2);
            }
            return Optional.of(result2.annotationType().getAnnotation(a));
        }
        Class<? extends Annotation> matchedType = result2.annotationType();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!matchedType.equals(a)) {
            Annotation typeAnnotation = matchedType.getAnnotation(a);
            Method[] methodArray = a.getDeclaredMethods();
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                Method method = methodArray[i];
                params.put(method.getName(), method.invoke((Object)typeAnnotation, new Object[0]));
            }
        }
        for (Method method : matchedType.getDeclaredMethods()) {
            params.put(method.getName(), method.invoke((Object)result2, new Object[0]));
        }
        if (Map.class.equals(returnType)) {
            return Optional.of(params);
        }
        return Optional.of(JsonUtils.convertValue(params, returnType));
    }

    public static boolean has(Class<? extends Annotation> annotationClass, Method method) {
        return ReflectionUtils.getMethodAnnotation(method, annotationClass).isPresent();
    }

    public static boolean has(Class<? extends Annotation> annotationClass, Parameter parameter) {
        for (Annotation annotation : parameter.getAnnotations()) {
            if (!ReflectionUtils.isOrHas(annotation, annotationClass)) continue;
            return true;
        }
        return false;
    }

    public static Optional<? extends Annotation> getMethodAnnotation(Executable m, Class<? extends Annotation> a) {
        Annotation result2;
        block3: {
            result2 = ReflectionUtils.getTopLevelAnnotation(m, a);
            Class<?> c = m.getDeclaringClass();
            if (result2 != null) break block3;
            Class<?> s = c;
            while (result2 == null && (s = s.getSuperclass()) != null) {
                result2 = ReflectionUtils.getAnnotationOnSuper(m, s, a);
            }
            if (result2 == null && m instanceof Method) {
                Class<?> s2;
                Iterator<Class<?>> iterator2 = ClassUtils.getAllInterfaces(c).iterator();
                while (iterator2.hasNext() && (result2 = ReflectionUtils.getAnnotationOnSuper(m, s2 = iterator2.next(), a)) == null) {
                }
            }
        }
        return Optional.ofNullable(result2);
    }

    private static Annotation getTopLevelAnnotation(Executable m, Class<? extends Annotation> a) {
        return Optional.ofNullable(m.getAnnotation(a)).orElseGet(() -> Arrays.stream(m.getAnnotations()).filter(other -> other.annotationType().isAnnotationPresent(a)).findFirst().orElse(null));
    }

    private static Annotation getAnnotationOnSuper(Executable m, Class<?> s, Class<? extends Annotation> a) {
        try {
            Method n = s.getDeclaredMethod(m.getName(), m.getParameterTypes());
            return ReflectionUtils.overrides(m, n) ? ReflectionUtils.getTopLevelAnnotation(n, a) : null;
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
    }

    private static boolean overrides(Executable a, Executable b) {
        int modsA = a.getModifiers();
        int modsB = b.getModifiers();
        if (Modifier.isPrivate(modsA) || Modifier.isPrivate(modsB)) {
            return false;
        }
        if (Modifier.isStatic(modsA) || Modifier.isStatic(modsB)) {
            return false;
        }
        if (Modifier.isFinal(modsB)) {
            return false;
        }
        if (ReflectionUtils.compareAccess(modsA, modsB) < 0) {
            return false;
        }
        return ReflectionUtils.notPackageAccess(modsA) && ReflectionUtils.notPackageAccess(modsB) || a.getDeclaringClass().getPackage().equals(b.getDeclaringClass().getPackage());
    }

    private static boolean notPackageAccess(int mods) {
        return (mods & 7) != 0;
    }

    private static int compareAccess(int lhs, int rhs) {
        return Integer.compare(ACCESS_ORDER.indexOf(lhs & 7), ACCESS_ORDER.indexOf(rhs & 7));
    }

    public static boolean classExists(String className) {
        try {
            ReflectionUtils.classForName(className);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <V> V copyFields(V source, V target) {
        if (target == null || source == null) {
            return target;
        }
        if (!source.getClass().equals(target.getClass())) {
            throw new IllegalArgumentException("Source and target class should be equal");
        }
        Class<?> type2 = source.getClass();
        if (type2.isPrimitive() || type2.isArray()) {
            return source;
        }
        while (type2 != null) {
            for (Field field : type2.getDeclaredFields()) {
                ReflectionUtils.ensureAccessible(field).set(target, field.get(source));
            }
            type2 = type2.getSuperclass();
        }
        return target;
    }

    private static Class<?> computeClass(String type2) {
        return Class.forName(type2.split("<")[0]);
    }

    private static final class PropertyNotFoundException
    extends RuntimeException {
        @NonNull
        private final String propertyName;
        @NonNull
        private final Class<?> type;

        @ConstructorProperties(value={"propertyName", "type"})
        public PropertyNotFoundException(@NonNull String propertyName, @NonNull Class<?> type2) {
            if (propertyName == null) {
                throw new NullPointerException("propertyName is marked non-null but is null");
            }
            if (type2 == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.propertyName = propertyName;
            this.type = type2;
        }

        @NonNull
        public String getPropertyName() {
            return this.propertyName;
        }

        @NonNull
        public Class<?> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyNotFoundException)) {
                return false;
            }
            PropertyNotFoundException other = (PropertyNotFoundException)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$propertyName = this.getPropertyName();
            String other$propertyName = other.getPropertyName();
            if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
                return false;
            }
            Class<?> this$type = this.getType();
            Class<?> other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PropertyNotFoundException;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            String $propertyName = this.getPropertyName();
            result2 = result2 * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
            Class<?> $type = this.getType();
            result2 = result2 * 59 + ($type == null ? 43 : $type.hashCode());
            return result2;
        }

        @Override
        public String toString() {
            return "ReflectionUtils.PropertyNotFoundException(propertyName=" + this.getPropertyName() + ", type=" + this.getType() + ")";
        }
    }
}

