/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.search;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fluxcapacitor.common.SearchUtils;
import io.fluxcapacitor.common.api.search.SearchDocuments;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class Document {
    public static Function<Document, ?> identityFunction = d -> String.format("%s_%s", d.getCollection(), d.getId());
    @NonNull
    private final String id;
    private final String type;
    private final int revision;
    private final String collection;
    private final Instant timestamp;
    private final Instant end;
    private final Map<Entry, List<Path>> entries;
    @JsonIgnore
    private final AtomicReference<Object> summarize = new AtomicReference();

    private String doSummarize() {
        return Stream.concat(Stream.of(this.type, this.id), this.getEntries().keySet().stream().map(Entry::asPhrase)).collect(Collectors.joining(" "));
    }

    public Optional<Entry> getEntryAtPath(String path) {
        return this.getMatchingEntries(Path.pathPredicate(path)).findFirst();
    }

    public Stream<Entry> getMatchingEntries(Predicate<Path> pathPredicate) {
        return this.entries.entrySet().stream().filter(e -> ((List)e.getValue()).stream().anyMatch(pathPredicate)).map(Map.Entry::getKey);
    }

    public Document filterPaths(Predicate<Path> pathFilter) {
        Map<Entry, List<Path>> filteredEntries = this.entries.entrySet().stream().flatMap(e -> {
            List filtered = ((List)e.getValue()).stream().filter(pathFilter).collect(Collectors.toList());
            if (filtered.isEmpty()) {
                return Stream.empty();
            }
            return Stream.of(((List)e.getValue()).size() == filtered.size() ? e : new AbstractMap.SimpleEntry((Entry)e.getKey(), filtered));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return this.toBuilder().entries(filteredEntries).build();
    }

    public Instant getEnd() {
        return this.end == null || this.timestamp == null || this.end.isAfter(this.timestamp) ? this.end : this.timestamp;
    }

    public static Comparator<Document> createComparator(SearchDocuments searchDocuments) {
        return searchDocuments.getSorting().stream().map(s -> {
            switch (s) {
                case "-timestamp": {
                    return Comparator.comparing(Document::getTimestamp, Comparator.nullsLast(Comparator.naturalOrder())).reversed();
                }
                case "timestamp": {
                    return Comparator.comparing(Document::getTimestamp, Comparator.nullsFirst(Comparator.naturalOrder()));
                }
            }
            boolean reversed = s.startsWith("-");
            String path = reversed ? s.substring(1) : s;
            Predicate<Path> pathPredicate = Path.pathPredicate(path);
            Comparator<Document> valueComparator = Comparator.nullsLast(Comparator.comparing(d -> {
                Stream<Entry> matchingEntries = d.getMatchingEntries(pathPredicate);
                return (reversed ? matchingEntries.max(Comparator.naturalOrder()) : matchingEntries.min(Comparator.naturalOrder())).orElse(null);
            }));
            return reversed ? valueComparator.reversed() : valueComparator;
        }).reduce(Comparator::thenComparing).orElseGet(() -> Comparator.comparing(Document::getTimestamp, Comparator.nullsLast(Comparator.naturalOrder())).reversed());
    }

    public static DocumentBuilder builder() {
        return new DocumentBuilder();
    }

    public DocumentBuilder toBuilder() {
        return new DocumentBuilder().id(this.id).type(this.type).revision(this.revision).collection(this.collection).timestamp(this.timestamp).end(this.end).entries(this.entries);
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getCollection() {
        return this.collection;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Map<Entry, List<Path>> getEntries() {
        return this.entries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document other = (Document)o;
        if (this.getRevision() != other.getRevision()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$collection = this.getCollection();
        String other$collection = other.getCollection();
        if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Instant this$end = this.getEnd();
        Instant other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        Map<Entry, List<Path>> this$entries = this.getEntries();
        Map<Entry, List<Path>> other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + this.getRevision();
        String $id = this.getId();
        result2 = result2 * 59 + ($id == null ? 43 : $id.hashCode());
        String $type = this.getType();
        result2 = result2 * 59 + ($type == null ? 43 : $type.hashCode());
        String $collection = this.getCollection();
        result2 = result2 * 59 + ($collection == null ? 43 : $collection.hashCode());
        Instant $timestamp = this.getTimestamp();
        result2 = result2 * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Instant $end = this.getEnd();
        result2 = result2 * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        Map<Entry, List<Path>> $entries = this.getEntries();
        result2 = result2 * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result2;
    }

    public String toString() {
        return "Document(id=" + this.getId() + ", type=" + this.getType() + ", revision=" + this.getRevision() + ", collection=" + this.getCollection() + ", timestamp=" + this.getTimestamp() + ", end=" + this.getEnd() + ", entries=" + this.getEntries() + ")";
    }

    @ConstructorProperties(value={"id", "type", "revision", "collection", "timestamp", "end", "entries"})
    public Document(@NonNull String id, String type2, int revision, String collection, Instant timestamp, Instant end, Map<Entry, List<Path>> entries) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
        this.type = type2;
        this.revision = revision;
        this.collection = collection;
        this.timestamp = timestamp;
        this.end = end;
        this.entries = entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String summarize() {
        Object value = this.summarize.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.summarize;
            synchronized (atomicReference) {
                value = this.summarize.get();
                if (value == null) {
                    String actualValue = this.doSummarize();
                    value = actualValue == null ? this.summarize : actualValue;
                    this.summarize.set(value);
                }
            }
        }
        return (String)(value == this.summarize ? null : value);
    }

    public static final class Path {
        public static final Pattern splitPattern = Pattern.compile("(?<!\\\\)/");
        private static final Pattern dotPattern = Pattern.compile("(?<!\\\\)\\.");
        private final String value;
        @JsonIgnore
        private final AtomicReference<Object> shortValue = new AtomicReference();
        @JsonIgnore
        private final AtomicReference<Object> longValue = new AtomicReference();

        public static String escapeFieldName(String fieldName) {
            fieldName = ((String)fieldName).replace("/", "\\/");
            if (StringUtils.isNumeric((CharSequence)(fieldName = ((String)fieldName).replace("\"", "\\\"")))) {
                try {
                    Integer.valueOf((String)fieldName);
                    fieldName = "\"" + (String)fieldName + "\"";
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return fieldName;
        }

        public static String unescapeFieldName(String fieldName) {
            if (fieldName.startsWith("\"") && fieldName.endsWith("\"")) {
                fieldName = fieldName.substring(1, fieldName.length() - 1);
            }
            fieldName = fieldName.replace("\\/", "/");
            fieldName = fieldName.replace("\\\"", "\"");
            return fieldName;
        }

        public static Predicate<Path> pathPredicate(String path) {
            if (path == null) {
                return p -> true;
            }
            path = dotPattern.matcher(path).replaceAll("/");
            Predicate<String> predicate = SearchUtils.convertGlobToRegex(path).asMatchPredicate();
            return splitPattern.splitAsStream(path).anyMatch(SearchUtils::isInteger) ? p -> predicate.test(p.getLongValue()) : p -> predicate.test(p.getShortValue());
        }

        @ConstructorProperties(value={"value"})
        public Path(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Path)) {
                return false;
            }
            Path other = (Path)o;
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            String $value = this.getValue();
            result2 = result2 * 59 + ($value == null ? 43 : $value.hashCode());
            return result2;
        }

        public String toString() {
            return "Document.Path(value=" + this.getValue() + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getShortValue() {
            Object value = this.shortValue.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.shortValue;
                synchronized (atomicReference) {
                    value = this.shortValue.get();
                    if (value == null) {
                        String actualValue = splitPattern.splitAsStream(this.getValue()).filter(p -> !SearchUtils.isInteger(p)).map(Path::unescapeFieldName).collect(Collectors.joining("/"));
                        value = actualValue == null ? this.shortValue : actualValue;
                        this.shortValue.set(value);
                    }
                }
            }
            return (String)(value == this.shortValue ? null : value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getLongValue() {
            Object value = this.longValue.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.longValue;
                synchronized (atomicReference) {
                    value = this.longValue.get();
                    if (value == null) {
                        String actualValue = splitPattern.splitAsStream(this.getValue()).map(Path::unescapeFieldName).collect(Collectors.joining("/"));
                        value = actualValue == null ? this.longValue : actualValue;
                        this.longValue.set(value);
                    }
                }
            }
            return (String)(value == this.longValue ? null : value);
        }
    }

    public static class DocumentBuilder {
        private String id;
        private String type;
        private int revision;
        private String collection;
        private Instant timestamp;
        private Instant end;
        private Map<Entry, List<Path>> entries;

        DocumentBuilder() {
        }

        public DocumentBuilder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        public DocumentBuilder type(String type2) {
            this.type = type2;
            return this;
        }

        public DocumentBuilder revision(int revision) {
            this.revision = revision;
            return this;
        }

        public DocumentBuilder collection(String collection) {
            this.collection = collection;
            return this;
        }

        public DocumentBuilder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public DocumentBuilder end(Instant end) {
            this.end = end;
            return this;
        }

        public DocumentBuilder entries(Map<Entry, List<Path>> entries) {
            this.entries = entries;
            return this;
        }

        public Document build() {
            return new Document(this.id, this.type, this.revision, this.collection, this.timestamp, this.end, this.entries);
        }

        public String toString() {
            return "Document.DocumentBuilder(id=" + this.id + ", type=" + this.type + ", revision=" + this.revision + ", collection=" + this.collection + ", timestamp=" + this.timestamp + ", end=" + this.end + ", entries=" + this.entries + ")";
        }
    }

    public static final class Entry
    implements Comparable<Entry> {
        private final EntryType type;
        private final String value;
        @JsonIgnore
        private final AtomicReference<Object> asPhrase = new AtomicReference();
        @JsonIgnore
        private final AtomicReference<Object> asNumber = new AtomicReference();

        @Override
        public int compareTo(@NonNull Entry o) {
            if (o == null) {
                throw new NullPointerException("o is marked non-null but is null");
            }
            if (this.type == EntryType.NUMERIC && this.type == o.getType()) {
                return this.asNumber().compareTo(o.asNumber());
            }
            return this.getValue().compareTo(o.getValue());
        }

        public EntryType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            EntryType this$type = this.getType();
            EntryType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            EntryType $type = this.getType();
            result2 = result2 * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $value = this.getValue();
            result2 = result2 * 59 + ($value == null ? 43 : $value.hashCode());
            return result2;
        }

        public String toString() {
            return "Document.Entry(type=" + this.getType() + ", value=" + this.getValue() + ")";
        }

        @ConstructorProperties(value={"type", "value"})
        public Entry(EntryType type2, String value) {
            this.type = type2;
            this.value = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String asPhrase() {
            Object value = this.asPhrase.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.asPhrase;
                synchronized (atomicReference) {
                    value = this.asPhrase.get();
                    if (value == null) {
                        String actualValue = this.getType() == EntryType.TEXT ? SearchUtils.normalize(this.getValue()) : this.getValue();
                        value = actualValue == null ? this.asPhrase : actualValue;
                        this.asPhrase.set(value);
                    }
                }
            }
            return (String)(value == this.asPhrase ? null : value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BigDecimal asNumber() {
            Object value = this.asNumber.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.asNumber;
                synchronized (atomicReference) {
                    value = this.asNumber.get();
                    if (value == null) {
                        BigDecimal actualValue = this.getType() == EntryType.NUMERIC ? new BigDecimal(this.getValue()) : null;
                        value = actualValue == null ? this.asNumber : actualValue;
                        this.asNumber.set(value);
                    }
                }
            }
            return (BigDecimal)(value == this.asNumber ? null : value);
        }
    }

    public static enum EntryType {
        TEXT(0),
        NUMERIC(1),
        BOOLEAN(2),
        NULL(3),
        EMPTY_ARRAY(4),
        EMPTY_OBJECT(5);

        private final byte index;

        private EntryType(int index) {
            this.index = (byte)index;
        }

        public byte serialize() {
            return this.index;
        }

        public static EntryType deserialize(byte b) {
            switch (b) {
                case 0: {
                    return TEXT;
                }
                case 1: {
                    return NUMERIC;
                }
                case 2: {
                    return BOOLEAN;
                }
                case 3: {
                    return NULL;
                }
                case 4: {
                    return EMPTY_ARRAY;
                }
                case 5: {
                    return EMPTY_OBJECT;
                }
            }
            throw new IllegalArgumentException("Cannot convert to EntryType: " + b);
        }
    }
}

