/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.search;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.fluxcapacitor.common.SearchUtils;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.search.Document;
import io.fluxcapacitor.common.search.Inverter;
import io.fluxcapacitor.common.serialization.NullCollectionsAsEmptyModule;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonInverter
implements Inverter<JsonNode> {
    private static final Logger log = LoggerFactory.getLogger(JacksonInverter.class);
    public static JsonMapper defaultObjectMapper = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).addModule(new NullCollectionsAsEmptyModule())).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS)).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).nodeFactory(JsonNodeFactory.withExactBigDecimals(true))).build();
    private final ObjectMapper objectMapper;
    private final JsonFactory jsonFactory;
    private final JsonNodeFactory nodeFactory;
    private final Pattern splitPattern = Document.Path.splitPattern;

    public JacksonInverter() {
        this(defaultObjectMapper);
    }

    public JacksonInverter(ObjectMapper objectMapper) {
        this.jsonFactory = objectMapper.getFactory();
        this.nodeFactory = objectMapper.getNodeFactory();
        this.objectMapper = objectMapper;
    }

    @Override
    public Document toDocument(Data<byte[]> data2, String id, String collection, Instant timestamp, Instant end) {
        if (!"application/json".equals(data2.getFormat())) {
            throw new IllegalArgumentException("Only json inversion is supported");
        }
        return new Document(id, data2.getType(), data2.getRevision(), collection, timestamp, end, this.invert(data2.getValue(), "", new LinkedHashMap<Document.Entry, List<Document.Path>>()));
    }

    protected Map<Document.Entry, List<Document.Path>> invert(byte[] json, String path, Map<Document.Entry, List<Document.Path>> valueMap) {
        try (JsonParser parser = this.jsonFactory.createParser(json);){
            JsonToken token = parser.nextToken();
            if (token != null) {
                this.processToken(token, valueMap, path, parser);
            }
        }
        return valueMap;
    }

    protected JsonToken processToken(JsonToken token, Map<Document.Entry, List<Document.Path>> valueMap, String path, JsonParser parser) {
        switch (token) {
            case START_ARRAY: {
                this.parseArray(parser, valueMap, path);
                break;
            }
            case START_OBJECT: {
                this.parseObject(parser, valueMap, path);
                break;
            }
            default: {
                this.registerValue(this.getEntryType(token), parser.getText(), path, valueMap);
            }
        }
        return parser.nextToken();
    }

    protected Document.EntryType getEntryType(JsonToken token) {
        switch (token) {
            case VALUE_STRING: {
                return Document.EntryType.TEXT;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return Document.EntryType.NUMERIC;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                return Document.EntryType.BOOLEAN;
            }
            case VALUE_NULL: {
                return Document.EntryType.NULL;
            }
        }
        throw new IllegalArgumentException("Unsupported value token: " + token);
    }

    protected void registerValue(Document.EntryType type2, String value, String path, Map<Document.Entry, List<Document.Path>> valueMap) {
        List locations = valueMap.computeIfAbsent(new Document.Entry(type2, value), key -> new ArrayList());
        if (!StringUtils.isBlank(path)) {
            locations.add(new Document.Path(path));
        }
    }

    private void parseArray(JsonParser parser, Map<Document.Entry, List<Document.Path>> valueMap, String root) {
        JsonToken token = parser.nextToken();
        if (token.isStructEnd()) {
            this.registerValue(Document.EntryType.EMPTY_ARRAY, "[]", (String)root, valueMap);
        } else {
            root = ((String)root).isEmpty() ? root : (String)root + "/";
            int i = 0;
            while (!token.isStructEnd()) {
                token = this.processToken(token, valueMap, (String)root + i, parser);
                ++i;
            }
        }
    }

    protected void parseObject(JsonParser parser, Map<Document.Entry, List<Document.Path>> valueMap, String root) {
        JsonToken token = parser.nextToken();
        if (token.isStructEnd()) {
            this.registerValue(Document.EntryType.EMPTY_OBJECT, "{}", (String)root, valueMap);
        } else {
            Object path = root = ((String)root).isEmpty() ? root : (String)root + "/";
            while (!token.isStructEnd()) {
                if (token == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getCurrentName();
                    fieldName = Document.Path.escapeFieldName(fieldName);
                    path = (String)root + fieldName;
                    token = parser.nextToken();
                    continue;
                }
                token = this.processToken(token, valueMap, (String)path, parser);
            }
        }
    }

    @Override
    public JsonNode fromDocument(Document document) {
        Pattern splitPattern = this.getSplitPattern();
        Map<Document.Entry, List<Document.Path>> entries = document.getEntries();
        if (entries.isEmpty()) {
            return NullNode.getInstance();
        }
        TreeMap tree = new TreeMap();
        for (Map.Entry<Document.Entry, List<Document.Path>> entry : entries.entrySet()) {
            JsonNode valueNode = this.toJsonNode(entry.getKey());
            List<Document.Path> paths = entry.getValue();
            if (paths.isEmpty()) {
                return valueNode;
            }
            paths.forEach(path -> {
                Map parent = tree;
                Iterator iterator2 = Arrays.stream(splitPattern.split(path.getValue())).iterator();
                while (iterator2.hasNext()) {
                    Object segment = SearchUtils.asIntegerOrString((String)iterator2.next());
                    if (iterator2.hasNext()) {
                        parent = (Map)parent.computeIfAbsent(segment, s -> new TreeMap());
                        continue;
                    }
                    JsonNode existing = parent.put(segment, valueNode);
                    if (existing == null) continue;
                    log.warn("Multiple entries share the same pointer: {} and {}", (Object)existing, (Object)valueNode);
                }
            });
        }
        return this.toJsonNode(tree);
    }

    protected JsonNode toJsonNode(Object struct) {
        if (struct instanceof Map) {
            SortedMap map = (SortedMap)struct;
            return map.keySet().stream().findFirst().map(firstKey -> firstKey instanceof Integer ? new ArrayNode(this.nodeFactory, map.values().stream().map(this::toJsonNode).collect(Collectors.toList())) : new ObjectNode(this.nodeFactory, map.entrySet().stream().collect(Collectors.toMap(e -> {
                String key = e.getKey().toString();
                key = Document.Path.unescapeFieldName(key);
                return key;
            }, e -> this.toJsonNode(e.getValue()))))).orElse(NullNode.getInstance());
        }
        if (struct instanceof JsonNode) {
            return (JsonNode)struct;
        }
        throw new IllegalArgumentException("Unrecognized structure: " + struct);
    }

    protected JsonNode toJsonNode(Document.Entry entry) {
        switch (entry.getType()) {
            case TEXT: {
                return new TextNode(entry.getValue());
            }
            case NUMERIC: {
                return new DecimalNode(new BigDecimal(entry.getValue()));
            }
            case BOOLEAN: {
                return BooleanNode.valueOf(Boolean.parseBoolean(entry.getValue()));
            }
            case NULL: {
                return NullNode.getInstance();
            }
            case EMPTY_ARRAY: {
                return new ArrayNode(this.nodeFactory);
            }
            case EMPTY_OBJECT: {
                return new ObjectNode(this.nodeFactory);
            }
        }
        throw new IllegalArgumentException("Unrecognized entry type: " + entry.getType());
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    protected JsonNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    protected Pattern getSplitPattern() {
        return this.splitPattern;
    }
}

