/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.fluxcapacitor.common.FileUtils;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.common.serialization.NullCollectionsAsEmptyModule;
import io.fluxcapacitor.common.serialization.StripStringsModule;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class JsonUtils {
    public static JsonMapper writer = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).addModule(new StripStringsModule())).addModule(new NullCollectionsAsEmptyModule())).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS)).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)).disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS)).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).nodeFactory(JsonNodeFactory.withExactBigDecimals(true))).serializationInclusion(JsonInclude.Include.NON_NULL)).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)).build();
    public static JsonMapper reader = (JsonMapper)((JsonMapper.Builder)writer.rebuild().activateDefaultTyping(LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, JsonTypeInfo.As.PROPERTY)).build();

    public static Object fromFile(String fileName) {
        return reader.readValue(FileUtils.loadFile(ReflectionUtils.getCallerClass(), fileName), Object.class);
    }

    public static List<?> fromFile(String ... fileNames) {
        Class<?> callerClass = ReflectionUtils.getCallerClass();
        return Arrays.stream(fileNames).map(f -> JsonUtils.fromFile(callerClass, f)).collect(Collectors.toList());
    }

    public static <T> T fromFile(String fileName, Class<T> type2) {
        return reader.readValue(FileUtils.loadFile(ReflectionUtils.getCallerClass(), fileName), type2);
    }

    public static <T> T fromFile(String fileName, JavaType javaType) {
        return reader.readValue(FileUtils.loadFile(ReflectionUtils.getCallerClass(), fileName), javaType);
    }

    public static <T> T fromFile(String fileName, Function<TypeFactory, JavaType> typeFunction) {
        return reader.readValue(FileUtils.loadFile(ReflectionUtils.getCallerClass(), fileName), typeFunction.apply(JsonUtils.typeFactory()));
    }

    public static <T> T fromFile(Class<?> referencePoint, String fileName) {
        return (T)reader.readValue(FileUtils.loadFile(referencePoint, fileName), Object.class);
    }

    public static <T> T fromFile(Class<?> referencePoint, String fileName, Class<T> type2) {
        return reader.readValue(FileUtils.loadFile(referencePoint, fileName), type2);
    }

    public static <T> T fromFile(Class<?> referencePoint, String fileName, JavaType javaType) {
        return reader.readValue(FileUtils.loadFile(referencePoint, fileName), javaType);
    }

    public static <T> T fromFile(Class<?> referencePoint, String fileName, Function<TypeFactory, JavaType> typeFunction) {
        return reader.readValue(FileUtils.loadFile(referencePoint, fileName), typeFunction.apply(JsonUtils.typeFactory()));
    }

    public static <T> T fromFileAs(String fileName) {
        return JsonUtils.fromFile(ReflectionUtils.getCallerClass(), fileName);
    }

    public static Object fromFileWith(String fileName, Map<String, Object> replaceValues) {
        Object o = JsonUtils.fromFile(ReflectionUtils.getCallerClass(), fileName);
        replaceValues.forEach((path, replacement) -> ReflectionUtils.writeProperty(path, o, replacement));
        return o;
    }

    public static <T> T fromJson(String json) {
        return (T)JsonUtils.fromJson(json, Object.class);
    }

    public static <T> T fromJson(String json, Class<T> type2) {
        return reader.readValue(json, type2);
    }

    public static <T> T fromJson(String json, JavaType type2) {
        return reader.readValue(json, type2);
    }

    public static <T> T fromJson(String json, Function<TypeFactory, JavaType> typeFunction) {
        return reader.readValue(json, typeFunction.apply(JsonUtils.typeFactory()));
    }

    public static <T> T fromJson(byte[] json, Class<T> type2) {
        return reader.readValue(json, type2);
    }

    public static String asJson(Object object) {
        return writer.writeValueAsString(object);
    }

    public static String asPrettyJson(Object object) {
        return writer.writerWithDefaultPrettyPrinter().writeValueAsString(object);
    }

    public static byte[] asBytes(Object object) {
        return writer.writeValueAsBytes(object);
    }

    public static <T> T convertValue(Object fromValue, Class<? extends T> toValueType) {
        return writer.convertValue(fromValue, toValueType);
    }

    public static JsonNode readTree(byte[] readEntity) {
        return writer.readTree(readEntity);
    }

    public static JsonNode readTree(String readEntity) {
        return writer.readTree(readEntity);
    }

    public static JsonNode readTree(InputStream readEntity) {
        return writer.readTree(readEntity);
    }

    public static <T extends JsonNode> T valueToTree(Object object) {
        return writer.valueToTree(object);
    }

    public static <T> T merge(T value, Object update) {
        if (value == null) {
            return (T)update;
        }
        return update == null ? value : writer.readerForUpdating(value).readValue(JsonUtils.convertValue(update, JsonNode.class));
    }

    public static TypeFactory typeFactory() {
        return reader.getTypeFactory();
    }
}

