/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;

public class StripStringsModule
extends SimpleModule {
    @Override
    public void setupModule(Module.SetupContext context) {
        this.addDeserializer(String.class, new BlankStringsToNullDeserializer());
        super.setupModule(context);
    }

    private static class BlankStringsToNullDeserializer
    extends StdScalarDeserializer<String> {
        public BlankStringsToNullDeserializer() {
            super(String.class);
        }

        @Override
        public String deserialize(JsonParser parser, DeserializationContext context) {
            String result2 = parser.getValueAsString().trim();
            return result2.isEmpty() ? null : result2;
        }
    }
}

