/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.serialization.compression;

import io.fluxcapacitor.common.serialization.compression.CompressionAlgorithm;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class CompressionUtils {
    private static final LZ4Compressor lz4Compressor = LZ4Factory.fastestInstance().fastCompressor();
    private static final LZ4FastDecompressor lz4Decompressor = LZ4Factory.fastestInstance().fastDecompressor();

    public static byte[] compress(byte[] uncompressed) {
        return CompressionUtils.compress(uncompressed, CompressionAlgorithm.LZ4);
    }

    public static byte[] compress(byte[] uncompressed, CompressionAlgorithm algorithm) {
        if (algorithm == null) {
            return uncompressed;
        }
        if (algorithm == CompressionAlgorithm.LZ4) {
            byte[] compressed = lz4Compressor.compress(uncompressed);
            return ByteBuffer.allocate(compressed.length + 4).putInt(uncompressed.length).put(compressed).array();
        }
        throw new UnsupportedOperationException("Unsupported compression algorithm: " + algorithm);
    }

    public static byte[] decompress(byte[] compressed) {
        return CompressionUtils.decompress(compressed, CompressionAlgorithm.LZ4);
    }

    public static byte[] decompress(byte[] compressed, CompressionAlgorithm algorithm) {
        if (algorithm == null) {
            return compressed;
        }
        if (algorithm == CompressionAlgorithm.LZ4) {
            ByteBuffer buffer = ByteBuffer.wrap(compressed);
            ByteBuffer result2 = ByteBuffer.allocate(buffer.getInt());
            lz4Decompressor.decompress(buffer, result2);
            return result2.array();
        }
        throw new UnsupportedOperationException("Unsupported compression algorithm: " + algorithm);
    }
}

