/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common;

import io.fluxcapacitor.common.api.HasMetadata;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.common.serialization.JsonUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.publishing.routing.RoutingKey;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public interface HasMessage
extends HasMetadata {
    public Message toMessage();

    default public <R> R getPayload() {
        return this.toMessage().getPayload();
    }

    default public <R> R getPayloadAs(Class<R> type2) {
        return JsonUtils.convertValue(this.getPayload(), type2);
    }

    default public Class<?> getPayloadClass() {
        Object payload = this.getPayload();
        return payload == null ? Void.class : payload.getClass();
    }

    default public Optional<String> computeRoutingKey() {
        Message m = this.toMessage();
        String routingValue = null;
        if (m.getPayload() != null) {
            Class<?> payloadType = m.getPayload().getClass();
            RoutingKey typeAnnotation = payloadType.getAnnotation(RoutingKey.class);
            if (typeAnnotation != null) {
                routingValue = this.getMetadata().get(typeAnnotation.metadataKey());
                if (routingValue == null) {
                    LoggerFactory.getLogger(HasMessage.class).warn("Did not find metadata routingValue for {} for routing key of message {} (id {})", typeAnnotation.metadataKey(), payloadType, m.getMessageId());
                } else {
                    return Optional.of(routingValue);
                }
            }
            routingValue = ReflectionUtils.getAnnotatedPropertyValue(m.getPayload(), RoutingKey.class).map(Object::toString).orElse(null);
        }
        if (routingValue == null && m instanceof Schedule) {
            routingValue = ((Schedule)m).getScheduleId();
        }
        return Optional.ofNullable(routingValue);
    }
}

