/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import java.beans.ConstructorProperties;
import java.io.IOException;

@JsonSerialize(using=CustomSerializer.class)
@JsonDeserialize(using=CustomDeserializer.class)
public class LazyId {
    private volatile String id;

    public LazyId() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId() {
        if (this.id == null) {
            LazyId lazyId = this;
            synchronized (lazyId) {
                if (this.id == null) {
                    this.id = FluxCapacitor.generateId();
                }
            }
        }
        return this.id;
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LazyId)) {
            return false;
        }
        LazyId other = (LazyId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LazyId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $id = this.getId();
        result2 = result2 * 59 + ($id == null ? 43 : $id.hashCode());
        return result2;
    }

    @ConstructorProperties(value={"id"})
    public LazyId(String id) {
        this.id = id;
    }

    static class CustomDeserializer
    extends StdScalarDeserializer<LazyId> {
        protected CustomDeserializer() {
            super(LazyId.class);
        }

        @Override
        public LazyId deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new LazyId(p.getText());
        }
    }

    static class CustomSerializer
    extends StdScalarSerializer<LazyId> {
        protected CustomSerializer() {
            super(LazyId.class);
        }

        @Override
        public void serialize(LazyId value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                gen.writeString(value.getId());
            }
        }
    }
}

