/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.casting;

import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.serialization.SerializationException;
import io.fluxcapacitor.javaclient.common.serialization.casting.AnnotatedCaster;
import io.fluxcapacitor.javaclient.common.serialization.casting.Cast;
import io.fluxcapacitor.javaclient.common.serialization.casting.CastParameters;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class CastInspector {
    public static boolean hasCasterMethods(Class<?> type2) {
        return ReflectionUtils.getAllMethods(type2).stream().anyMatch(m -> ReflectionUtils.has(Cast.class, m));
    }

    public static <T> List<AnnotatedCaster<T>> getCasters(Class<? extends Annotation> castAnnotation, Collection<?> candidateTargets, Class<T> dataType, Comparator<AnnotatedCaster<?>> casterComparator) {
        ArrayList result2 = new ArrayList();
        for (Object caster : candidateTargets) {
            ReflectionUtils.getAllMethods(caster.getClass()).forEach(m -> CastInspector.createCaster(caster, m, dataType, castAnnotation).ifPresent(result2::add));
        }
        result2.sort(casterComparator);
        return result2;
    }

    private static <T> Optional<AnnotatedCaster<T>> createCaster(Object target, Method m, Class<T> dataType, Class<? extends Annotation> castAnnotation) {
        if (!ReflectionUtils.has(castAnnotation, m)) {
            return Optional.empty();
        }
        return ReflectionUtils.getAnnotationAs(m, Cast.class, CastParameters.class).map(params -> CastInspector.createCaster(params, m, target, dataType));
    }

    private static <T> AnnotatedCaster<T> createCaster(CastParameters castParameters, Method method, Object target, Class<T> dataType) {
        if (ReflectionUtils.ensureAccessible(method).getReturnType().equals(Void.TYPE)) {
            return new AnnotatedCaster(method, castParameters, i -> Stream.empty());
        }
        Function invokeFunction = CastInspector.invokeFunction(method, target, dataType);
        BiFunction resultMapper = CastInspector.mapResult(castParameters, method, dataType);
        return new AnnotatedCaster(method, castParameters, d -> (Stream)resultMapper.apply((SerializedObject)d, () -> invokeFunction.apply((SerializedObject)d)));
    }

    private static <T> Function<SerializedObject<T, ?>, Object> invokeFunction(Method method, Object target, Class<T> dataType) {
        Type[] parameters2 = method.getGenericParameterTypes();
        if (parameters2.length > 1) {
            throw new SerializationException(String.format("Upcaster method '%s' has unexpected number of parameters. Expected 1 or 0.", method));
        }
        if (parameters2.length == 0) {
            return s -> CastInspector.invokeMethod(method, null, target);
        }
        if (parameters2[0] instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)parameters2[0];
            if (parameterizedType.getRawType().equals(Data.class) && dataType.isAssignableFrom((Class)parameterizedType.getActualTypeArguments()[0])) {
                return s -> CastInspector.invokeMethod(method, s.data(), target);
            }
            if (dataType.isAssignableFrom((Class)parameterizedType.getRawType())) {
                return s -> CastInspector.invokeMethod(method, s.data().getValue(), target);
            }
        } else if (dataType.isAssignableFrom((Class)parameters2[0])) {
            return s -> CastInspector.invokeMethod(method, s.data().getValue(), target);
        }
        throw new SerializationException(String.format("First parameter in upcaster method '%s' is of unexpected type. Expected Data<%s> or %s.", method, dataType.getName(), dataType.getName()));
    }

    private static Object invokeMethod(Method method, Object argument, Object target) {
        try {
            return argument == null ? method.invoke(target, new Object[0]) : method.invoke(target, argument);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Not allowed to invoke method: " + method, e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException("Exception while upcasting using method: " + method, e);
        }
    }

    private static <T> BiFunction<SerializedObject<T, ?>, Supplier<Object>, Stream<SerializedObject<T, ?>>> mapResult(CastParameters annotation, Method method, Class<T> dataType) {
        if (dataType.isAssignableFrom(method.getReturnType())) {
            return (s, o) -> Stream.of(s.withData(new Data(o, annotation.type(), annotation.revision() + annotation.revisionDelta(), s.data().getFormat())));
        }
        if (method.getReturnType().equals(Data.class)) {
            return (s, o) -> Stream.of(s.withData((Data)o.get()));
        }
        if (method.getReturnType().equals(Optional.class)) {
            ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
            if (parameterizedType.getActualTypeArguments()[0] instanceof Class) {
                Class typeParameter = (Class)parameterizedType.getActualTypeArguments()[0];
                if (dataType.isAssignableFrom(typeParameter)) {
                    return (s, o) -> {
                        Optional result2 = (Optional)o.get();
                        return result2.stream().map(t -> s.withData(new Data<Object>(t, annotation.type(), annotation.revision() + annotation.revisionDelta(), s.data().getFormat())));
                    };
                }
            } else if (parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType && ((ParameterizedType)parameterizedType.getActualTypeArguments()[0]).getRawType().equals(Data.class)) {
                return (s, o) -> ((Optional)o.get()).stream().map(s::withData);
            }
        }
        if (method.getReturnType().equals(Stream.class)) {
            return (s, o) -> ((Stream)o.get()).map(s::withData);
        }
        throw new SerializationException(String.format("Unexpected return type of upcaster method '%s'. Expected Data<%s>, %s, Optional<Data<%s>>, Optional<%s>, Stream<Data<%s>> or void", method, dataType.getName(), dataType.getName(), dataType.getName(), dataType.getName(), dataType.getName()));
    }
}

