/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.HandlerMatcher;
import io.fluxcapacitor.javaclient.common.serialization.ContentFilter;
import io.fluxcapacitor.javaclient.common.serialization.FilterContent;
import io.fluxcapacitor.javaclient.tracking.handling.InputParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.CurrentUserParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonContentFilter
implements ContentFilter {
    private static final Logger log = LoggerFactory.getLogger(JacksonContentFilter.class);
    private final ObjectMapper mapper;

    public JacksonContentFilter(ObjectMapper mapper) {
        mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        mapper.registerModule(new SimpleModule(){

            @Override
            public void setupModule(Module.SetupContext context) {
                super.setupModule(context);
                context.addBeanSerializerModifier(new BeanSerializerModifier(){

                    @Override
                    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription desc, JsonSerializer<?> serializer) {
                        return new FilteringSerializer(serializer);
                    }
                });
            }
        });
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T filterContent(T value, User viewer) {
        try {
            FilteringSerializer.rootValue.set(value);
            Object object = viewer.apply(() -> this.mapper.convertValue(value, value.getClass()));
            return (T)object;
        }
        catch (Exception e) {
            log.warn("Failed to filter content (type {}) for viewer {}", value.getClass(), viewer, e);
            Object t = value;
            return t;
        }
        finally {
            FilteringSerializer.rootValue.remove();
        }
    }

    protected static class FilteringSerializer
    extends JsonSerializer<Object> {
        private static final Logger log = LoggerFactory.getLogger(FilteringSerializer.class);
        protected static final ThreadLocal<Object> rootValue = new ThreadLocal();
        private final Function<Class<?>, HandlerMatcher<Object, Object>> matcherCache = ObjectUtils.memoize(type2 -> HandlerInspector.inspect(type2, List.of(new CurrentUserParameterResolver(), new InputParameterResolver()), FilterContent.class));
        private final JsonSerializer<Object> defaultSerializer;

        @Override
        public void serialize(Object input, JsonGenerator jsonGenerator, SerializerProvider provider) {
            Object value = input;
            try {
                Optional<HandlerInvoker> invoker;
                if (value != null && (invoker = this.matcherCache.apply(value.getClass()).findInvoker(value, rootValue.get())).isPresent() && (value = invoker.get().invoke()) == null) {
                    if (!jsonGenerator.getOutputContext().inArray()) {
                        jsonGenerator.writeNull();
                    }
                    return;
                }
            }
            catch (Exception e) {
                log.warn("Failed to filter content (type {}) for viewer {}", input.getClass(), User.getCurrent(), e);
            }
            this.defaultSerializer.serialize(value, jsonGenerator, provider);
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, Object value) {
            if (super.isEmpty(provider, value)) {
                return true;
            }
            try {
                return this.matcherCache.apply(value.getClass()).findInvoker(value, rootValue.get()).filter(handlerInvoker -> handlerInvoker.invoke() == null).isPresent();
            }
            catch (Exception ignored) {
                return false;
            }
        }

        @ConstructorProperties(value={"defaultSerializer"})
        public FilteringSerializer(JsonSerializer<Object> defaultSerializer) {
            this.defaultSerializer = defaultSerializer;
        }
    }
}

