/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.websocket;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Backlog;
import io.fluxcapacitor.common.RetryConfiguration;
import io.fluxcapacitor.common.TimingUtils;
import io.fluxcapacitor.common.api.Command;
import io.fluxcapacitor.common.api.JsonType;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.QueryResult;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.common.api.RequestBatch;
import io.fluxcapacitor.common.api.ResultBatch;
import io.fluxcapacitor.common.serialization.compression.CompressionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.websocket.SessionPool;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import java.beans.ConstructorProperties;
import java.io.OutputStream;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebsocketClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(AbstractWebsocketClient.class);
    public static WebSocketContainer defaultWebSocketContainer = ContainerProvider.getWebSocketContainer();
    public static ObjectMapper defaultObjectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).findAndAddModules()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)).build();
    private final SessionPool sessionPool;
    private final WebSocketClient.ClientConfig clientConfig;
    private final ObjectMapper objectMapper;
    private final Map<Long, WebSocketRequest> requests = new ConcurrentHashMap<Long, WebSocketRequest>();
    private final Map<String, Backlog<JsonType>> sessionBacklogs = new ConcurrentHashMap<String, Backlog<JsonType>>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ExecutorService resultExecutor = Executors.newFixedThreadPool(8);
    private final boolean sendMetrics;

    public AbstractWebsocketClient(URI endpointUri, WebSocketClient.ClientConfig clientConfig, boolean sendMetrics) {
        this(endpointUri, clientConfig, sendMetrics, 1);
    }

    public AbstractWebsocketClient(URI endpointUri, WebSocketClient.ClientConfig clientConfig, boolean sendMetrics, int numberOfSessions) {
        this(defaultWebSocketContainer, endpointUri, clientConfig, sendMetrics, Duration.ofSeconds(1L), defaultObjectMapper, numberOfSessions);
    }

    public AbstractWebsocketClient(WebSocketContainer container, URI endpointUri, WebSocketClient.ClientConfig clientConfig, boolean sendMetrics, Duration reconnectDelay, ObjectMapper objectMapper, int numberOfSessions) {
        this.clientConfig = clientConfig;
        this.objectMapper = objectMapper;
        this.sendMetrics = sendMetrics;
        this.sessionPool = new SessionPool(numberOfSessions, () -> TimingUtils.retryOnFailure(() -> container.connectToServer(this, endpointUri), RetryConfiguration.builder().delay(reconnectDelay).errorTest(e -> !this.closed.get()).successLogger(s -> log.info("Successfully reconnected to endpoint {}", (Object)endpointUri)).exceptionLogger(status -> {
            if (status.getNumberOfTimesRetried() == 0) {
                log.warn("Failed to connect to endpoint {}; reason: {}. Retrying every {} ms...", endpointUri, status.getException().getMessage(), status.getRetryConfiguration().getDelay().toMillis());
            }
        }).build()));
    }

    protected <R extends QueryResult> CompletableFuture<R> send(Request request) {
        return new WebSocketRequest(request, FluxCapacitor.currentCorrelationData()).send();
    }

    protected <R extends QueryResult> R sendAndWait(Request request) {
        return (R)((QueryResult)this.send(request).get());
    }

    protected Awaitable sendAndForget(JsonType object) {
        return this.send(object, this.sessionPool.get());
    }

    protected Awaitable sendCommand(Command command) {
        switch (command.getGuarantee()) {
            case NONE: {
                this.sendAndForget(command);
                return Awaitable.ready();
            }
            case SENT: {
                return this.sendAndForget(command);
            }
        }
        return Awaitable.fromFuture(this.send(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Awaitable send(JsonType object, Session session) {
        Awaitable awaitable;
        try {
            awaitable = this.sessionBacklogs.computeIfAbsent(session.getId(), id -> new Backlog(batch -> this.sendBatch(batch, session))).add(object);
        }
        catch (Throwable throwable) {
            this.tryPublishMetrics(object, object instanceof Request ? Metadata.of((Object)"requestId", (Object)((Request)object).getRequestId()) : Metadata.empty());
            throw throwable;
        }
        this.tryPublishMetrics(object, object instanceof Request ? Metadata.of((Object)"requestId", (Object)((Request)object).getRequestId()) : Metadata.empty());
        return awaitable;
    }

    protected Awaitable sendBatch(List<JsonType> requests, Session session) {
        JsonType object = requests.size() == 1 ? requests.get(0) : new RequestBatch<JsonType>(requests);
        try (OutputStream outputStream = session.getBasicRemote().getSendStream();){
            byte[] bytes = this.objectMapper.writeValueAsBytes(object);
            outputStream.write(CompressionUtils.compress(bytes, this.clientConfig.getCompression()));
        }
        catch (Exception e) {
            log.error("Failed to send request {}", (Object)object, (Object)e);
            throw e;
        }
        return Awaitable.ready();
    }

    @OnMessage
    public void onMessage(byte[] bytes) {
        this.resultExecutor.execute(() -> {
            JsonType value;
            try {
                value = this.objectMapper.readValue(CompressionUtils.decompress(bytes, this.clientConfig.getCompression()), JsonType.class);
            }
            catch (Exception e) {
                log.error("Could not parse input. Expected a Json message.", e);
                return;
            }
            if (value instanceof ResultBatch) {
                String batchId = FluxCapacitor.generateId();
                ((ResultBatch)value).getResults().forEach(r -> this.resultExecutor.execute(() -> this.handleResult((QueryResult)r, batchId)));
            } else {
                this.handleResult((QueryResult)value, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleResult(QueryResult result2, String batchId) {
        block6: {
            try {
                WebSocketRequest webSocketRequest = this.requests.remove(result2.getRequestId());
                if (webSocketRequest == null) {
                    log.warn("Could not find outstanding read request for id {}", (Object)result2.getRequestId());
                    break block6;
                }
                try {
                    Metadata metadata2 = Metadata.of("requestId", webSocketRequest.request.getRequestId(), "msDuration", System.currentTimeMillis() - webSocketRequest.sendTimestamp).with(webSocketRequest.correlationData);
                    this.tryPublishMetrics(result2, batchId == null ? metadata2 : metadata2.with((Object)"batchId", (Object)batchId));
                }
                finally {
                    webSocketRequest.result.complete(result2);
                }
            }
            catch (Throwable e) {
                log.error("Failed to handle result {}", (Object)result2, (Object)e);
            }
        }
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        this.sessionBacklogs.remove(session.getId());
        if (closeReason.getCloseCode().getCode() > CloseReason.CloseCodes.NO_STATUS_CODE.getCode()) {
            log.warn("Connection to endpoint {} closed with reason {}", (Object)session.getRequestURI(), (Object)closeReason);
        }
        this.retryOutstandingRequests(session.getId());
    }

    protected void retryOutstandingRequests(String sessionId) {
        if (!this.closed.get() && !this.requests.isEmpty()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Thread interrupted while trying to retry outstanding requests", e);
            }
            this.requests.values().stream().filter(r -> sessionId.equals(r.sessionId)).forEach(WebSocketRequest::send);
        }
    }

    @OnError
    public void onError(Session session, Throwable e) {
        log.error("Client side error for web socket connected to endpoint {}", (Object)session.getRequestURI(), (Object)e);
    }

    @Override
    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(boolean clearOutstandingRequests) {
        if (this.closed.compareAndSet(false, true)) {
            AtomicBoolean atomicBoolean = this.closed;
            synchronized (atomicBoolean) {
                if (clearOutstandingRequests) {
                    this.requests.clear();
                }
                this.sessionPool.close();
                if (!this.requests.isEmpty()) {
                    log.warn("{}: Closed websocket session to endpoint with {} outstanding requests", (Object)this.getClass().getSimpleName(), (Object)this.requests.size());
                }
            }
        }
    }

    protected void tryPublishMetrics(JsonType message, Metadata metadata2) {
        Object metric = message.toMetric();
        if (this.sendMetrics && metric != null) {
            FluxCapacitor.getOptionally().ifPresent(f -> FluxCapacitor.publishMetrics(metric, metadata2));
        }
    }

    protected class WebSocketRequest {
        private final Request request;
        private final CompletableFuture<QueryResult> result = new CompletableFuture();
        private final Map<String, String> correlationData;
        private volatile String sessionId;
        private volatile long sendTimestamp;

        protected <T extends QueryResult> CompletableFuture<T> send() {
            Session session;
            try {
                session = AbstractWebsocketClient.this.sessionPool.get();
            }
            catch (Exception e) {
                log.error("Failed to get websocket session to send request {}", (Object)this.request, (Object)e);
                this.result.completeExceptionally(e);
                return this.result;
            }
            this.sessionId = session.getId();
            AbstractWebsocketClient.this.requests.put(this.request.getRequestId(), this);
            try {
                this.sendTimestamp = System.currentTimeMillis();
                AbstractWebsocketClient.this.send(this.request, session);
            }
            catch (Exception e) {
                AbstractWebsocketClient.this.requests.remove(this.request.getRequestId());
                this.result.completeExceptionally(e);
            }
            return this.result;
        }

        @ConstructorProperties(value={"request", "correlationData"})
        public WebSocketRequest(Request request, Map<String, String> correlationData) {
            this.request = request;
            this.correlationData = correlationData;
        }
    }
}

