/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.spring;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.common.serialization.casting.CastInspector;
import io.fluxcapacitor.javaclient.common.serialization.jackson.JacksonSerializer;
import io.fluxcapacitor.javaclient.configuration.DefaultFluxCapacitor;
import io.fluxcapacitor.javaclient.configuration.FluxCapacitorBuilder;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.configuration.client.InMemoryClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.configuration.spring.ConditionalOnMissingBean;
import io.fluxcapacitor.javaclient.persisting.caching.Cache;
import io.fluxcapacitor.javaclient.persisting.keyvalue.KeyValueStore;
import io.fluxcapacitor.javaclient.persisting.repository.AggregateRepository;
import io.fluxcapacitor.javaclient.persisting.search.DocumentStore;
import io.fluxcapacitor.javaclient.publishing.CommandGateway;
import io.fluxcapacitor.javaclient.publishing.ErrorGateway;
import io.fluxcapacitor.javaclient.publishing.EventGateway;
import io.fluxcapacitor.javaclient.publishing.MetricsGateway;
import io.fluxcapacitor.javaclient.publishing.QueryGateway;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.scheduling.Scheduler;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.context.support.GenericApplicationContext;

@Configuration
public class FluxCapacitorSpringConfig
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(FluxCapacitorSpringConfig.class);
    private final ApplicationContext context;
    private final List<Object> springBeans = new CopyOnWriteArrayList<Object>();
    private final AtomicReference<Registration> handlerRegistration = new AtomicReference();

    @Autowired
    protected FluxCapacitorSpringConfig(ApplicationContext context) {
        this.context = context;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.springBeans.add(bean);
        return bean;
    }

    @EventListener
    public void handle(ContextRefreshedEvent event) {
        FluxCapacitor fluxCapacitor = (FluxCapacitor)this.context.getBean(FluxCapacitor.class);
        List potentialHandlers = this.springBeans.stream().filter(b -> !(b instanceof Class)).collect(Collectors.toList());
        this.handlerRegistration.updateAndGet(r -> r == null ? fluxCapacitor.registerHandlers(potentialHandlers) : r);
        if (Thread.getDefaultUncaughtExceptionHandler() == null) {
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> log.error("Uncaught exception", e));
        }
        if (event.getApplicationContext() instanceof GenericApplicationContext) {
            ((GenericApplicationContext)event.getApplicationContext()).start();
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public Serializer serializer() {
        ArrayList upcasters = new ArrayList();
        for (String beanName : this.context.getBeanDefinitionNames()) {
            Optional.ofNullable(this.context.getType(beanName)).filter(CastInspector::hasCasterMethods).ifPresent(t -> upcasters.add(this.context.getAutowireCapableBeanFactory().getBean(beanName)));
        }
        return new JacksonSerializer(upcasters);
    }

    @Bean
    @ConditionalOnMissingBean
    public FluxCapacitorBuilder fluxCapacitorBuilder(Serializer serializer, Optional<UserProvider> userProvider, Optional<Cache> cache2) {
        FluxCapacitorBuilder builder = DefaultFluxCapacitor.builder().disableShutdownHook().replaceSerializer(serializer).replaceSnapshotSerializer(serializer).makeApplicationInstance(true);
        userProvider.ifPresent(builder::registerUserSupplier);
        cache2.ifPresent(builder::replaceCache);
        return builder;
    }

    @Bean
    @ConditionalOnMissingBean
    public FluxCapacitor fluxCapacitor(FluxCapacitorBuilder builder) {
        Client client = this.getBean(Client.class).orElseGet(() -> this.getBean(WebSocketClient.ClientConfig.class).map(WebSocketClient::newInstance).orElseGet(() -> {
            log.info("Using in-memory Flux Capacitor client");
            return InMemoryClient.newInstance();
        }));
        return builder.build(client);
    }

    @Bean
    @ConditionalOnMissingBean
    public AggregateRepository aggregateRepository(FluxCapacitor fluxCapacitor) {
        return fluxCapacitor.aggregateRepository();
    }

    @Bean
    @ConditionalOnMissingBean
    public Scheduler scheduler(FluxCapacitor fluxCapacitor) {
        return fluxCapacitor.scheduler();
    }

    @Bean
    @ConditionalOnMissingBean
    public CommandGateway commandGateway(FluxCapacitor fluxCapacitor) {
        return fluxCapacitor.commandGateway();
    }

    @Bean
    @ConditionalOnMissingBean
    public EventGateway eventGateway(FluxCapacitor fluxCapacitor) {
        return fluxCapacitor.eventGateway();
    }

    @Bean
    @ConditionalOnMissingBean
    public QueryGateway queryGateway(FluxCapacitor fluxCapacitor) {
        return fluxCapacitor.queryGateway();
    }

    @Bean
    @ConditionalOnMissingBean
    public ErrorGateway errorGateway(FluxCapacitor fluxCapacitor) {
        return fluxCapacitor.errorGateway();
    }

    @Bean
    @ConditionalOnMissingBean
    public MetricsGateway metricsGateway(FluxCapacitor fluxCapacitor) {
        return fluxCapacitor.metricsGateway();
    }

    @Bean
    @ConditionalOnMissingBean
    public ResultGateway resultGateway(FluxCapacitor fluxCapacitor) {
        return fluxCapacitor.resultGateway();
    }

    @Bean
    @ConditionalOnMissingBean
    public KeyValueStore keyValueStore(FluxCapacitor fluxCapacitor) {
        return fluxCapacitor.keyValueStore();
    }

    @Bean
    @ConditionalOnMissingBean
    public DocumentStore documentStore(FluxCapacitor fluxCapacitor) {
        return fluxCapacitor.documentStore();
    }

    protected <T> Optional<T> getBean(Class<T> type2) {
        return this.context.getBeansOfType(type2).values().stream().findFirst();
    }
}

